/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.ILValueIterator;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.statet.ecommons.waltable.persistence.IPersistable;
import org.eclipse.statet.ecommons.waltable.persistence.StylePersistor;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.style.Style;
import org.eclipse.statet.ecommons.waltable.style.editor.ColumnStyleEditorDialog;
import org.eclipse.statet.ecommons.waltable.style.editor.DisplayColumnStyleEditorCommand;
import org.eclipse.swt.widgets.Display;

public class DisplayColumnStyleEditorCommandHandler
extends AbstractLayerCommandHandler<DisplayColumnStyleEditorCommand>
implements IPersistable {
    protected static final String PERSISTENCE_PREFIX = "userDefinedColumnStyle";
    protected static final String USER_EDITED_STYLE_LABEL = "USER_EDITED_STYLE_FOR_INDEX_";
    protected final SelectionLayer selectionLayer;
    protected ColumnOverrideLabelAccumulator columnLabelAccumulator;
    private final IConfigRegistry configRegistry;
    protected ColumnStyleEditorDialog dialog;
    protected final Map<String, Style> stylesToPersist = new HashMap<String, Style>();

    public DisplayColumnStyleEditorCommandHandler(SelectionLayer selectionLayer, ColumnOverrideLabelAccumulator labelAccumulator, IConfigRegistry configRegistry) {
        this.selectionLayer = selectionLayer;
        this.columnLabelAccumulator = labelAccumulator;
        this.configRegistry = configRegistry;
    }

    @Override
    public boolean doCommand(DisplayColumnStyleEditorCommand command) {
        long columnIndexOfClick = command.getNattableLayer().getDim(Orientation.HORIZONTAL).getPositionId(command.columnPosition, command.columnPosition);
        LabelStack configLabels = new LabelStack();
        this.columnLabelAccumulator.accumulateConfigLabels(configLabels, columnIndexOfClick, 0L);
        configLabels.addLabel(this.getConfigLabel(columnIndexOfClick));
        Style clickedCellStyle = (Style)this.configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, configLabels.getLabels());
        this.dialog = new ColumnStyleEditorDialog(Display.getCurrent().getActiveShell(), clickedCellStyle);
        this.dialog.open();
        if (this.dialog.isCancelPressed()) {
            return true;
        }
        this.applySelectedStyleToColumns(command, this.selectionLayer.getSelectedColumnPositions());
        return true;
    }

    @Override
    public Class<DisplayColumnStyleEditorCommand> getCommandClass() {
        return DisplayColumnStyleEditorCommand.class;
    }

    protected void applySelectedStyleToColumns(DisplayColumnStyleEditorCommand command, LRangeList columnPositions) {
        ILValueIterator columnIter = columnPositions.values().iterator();
        while (columnIter.hasNext()) {
            long position = columnIter.nextValue();
            long columnIndex = this.selectionLayer.getDim(Orientation.HORIZONTAL).getPositionId(position, position);
            Style newColumnCellStyle = this.dialog.getNewColumnCellStyle();
            String configLabel = this.getConfigLabel(columnIndex);
            if (newColumnCellStyle == null) {
                this.stylesToPersist.remove(configLabel);
            } else {
                newColumnCellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.dialog.getNewColumnBorderStyle());
                this.stylesToPersist.put(configLabel, newColumnCellStyle);
            }
            this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, newColumnCellStyle, DisplayMode.NORMAL, configLabel);
            this.columnLabelAccumulator.registerColumnOverridesOnTop(columnIndex, configLabel);
        }
    }

    protected String getConfigLabel(long columnIndex) {
        return USER_EDITED_STYLE_LABEL + columnIndex;
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        prefix = String.valueOf(prefix) + "." + PERSISTENCE_PREFIX;
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            String keyString = (String)key;
            if (!keyString.contains(PERSISTENCE_PREFIX)) continue;
            long colIndex = this.parseColumnIndexFromKey(keyString);
            if (this.stylesToPersist.keySet().contains(this.getConfigLabel(colIndex))) continue;
            Style savedStyle = StylePersistor.loadStyle(String.valueOf(prefix) + "." + this.getConfigLabel(colIndex), properties);
            this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, savedStyle, DisplayMode.NORMAL, this.getConfigLabel(colIndex));
            this.stylesToPersist.put(this.getConfigLabel(colIndex), savedStyle);
            this.columnLabelAccumulator.registerColumnOverrides(colIndex, this.getConfigLabel(colIndex));
        }
    }

    protected long parseColumnIndexFromKey(String keyString) {
        int colLabelStartIndex = keyString.indexOf(USER_EDITED_STYLE_LABEL);
        String columnConfigLabel = keyString.substring(colLabelStartIndex, keyString.indexOf(46, colLabelStartIndex));
        int lastUnderscoreInLabel = columnConfigLabel.lastIndexOf(95, colLabelStartIndex);
        return Long.parseLong(columnConfigLabel.substring(lastUnderscoreInLabel + 1));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        prefix = String.valueOf(prefix) + "." + PERSISTENCE_PREFIX;
        for (Map.Entry<String, Style> labelToStyle : this.stylesToPersist.entrySet()) {
            Style style = labelToStyle.getValue();
            String label = labelToStyle.getKey();
            StylePersistor.saveStyle(String.valueOf(prefix) + "." + label, properties, style);
        }
    }
}

