/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srvext.auth;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.server.FxCallback;
import org.eclipse.statet.rj.server.srvext.ServerAuthMethod;
import org.eclipse.statet.rj.server.util.ServerUtils;

@NonNullByDefault
public class FxAuthMethod
extends ServerAuthMethod {
    private final byte[] pendingKey = new byte[1024];
    private File file = (File)ObjectUtils.nonNullLateInit();
    private FileChannel fileChannel = (FileChannel)ObjectUtils.nonNullLateInit();

    public FxAuthMethod() {
        super("fx", false);
    }

    @Override
    public void doInit(@Nullable String arg) throws RjException {
        ServerUtils.ArgKeyValue config = ServerUtils.getArgConfigValue(arg);
        if (config.getKey().equals("file")) {
            String fileName = config.getValue();
            if (fileName == null || fileName.isEmpty()) {
                throw new RjException("Missing lock file name.", null);
            }
            this.file = new File(fileName);
            try {
                if (!this.file.exists()) {
                    this.file.createNewFile();
                }
                this.fileChannel = new RandomAccessFile(this.file, "rws").getChannel();
                this.fileChannel.truncate(512L);
            }
            catch (IOException e) {
                throw new RjException("Cannot read lock file.", e);
            }
        } else {
            throw new RjException(String.format("Unsupported configuration type '%1$s'.", config.getKey()));
        }
    }

    @Override
    protected ImList<Callback> doCreateLogin() throws RjException {
        this.getRandom().nextBytes(this.pendingKey);
        try {
            this.fileChannel.position(this.fileChannel.size());
        }
        catch (IOException e) {
            throw new RjException("Cannot read lock file.", e);
        }
        return ImCollections.newList((Object[])new Callback[]{new NameCallback("Username"), new FxCallback(this.file.getPath(), this.pendingKey)});
    }

    @Override
    protected String doPerformLogin(ImList<Callback> callbacks) throws LoginException, RjException {
        String userName = ((NameCallback)callbacks.get(0)).getName();
        if (userName == null) {
            throw new RjException("Username is missing.");
        }
        byte[] clientKey = ((FxCallback)callbacks.get(1)).getContent();
        if (clientKey.length < 1024) {
            throw new RjException("Unsufficient client key");
        }
        try {
            if (this.compare(this.pendingKey) && this.compare(clientKey)) {
                return userName;
            }
        }
        catch (IOException e) {
            throw new RjException("Cannot read lock file.", e);
        }
        throw new FailedLoginException();
    }

    private boolean compare(byte[] key) throws IOException {
        byte[] check = new byte[key.length];
        int n = this.fileChannel.read(ByteBuffer.wrap(check));
        if (n != key.length) {
            return false;
        }
        return Arrays.equals(key, check);
    }
}

