/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.io;

import java.net.URISyntaxException;
import org.eclipse.statet.internal.jcommons.io.AbstractNestedArchiveStringUrl;
import org.eclipse.statet.internal.jcommons.io.CommonsUriInternals;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class NestedJarBoot2StringUrl
extends AbstractNestedArchiveStringUrl {
    private final int nestSepIndex;
    private final int jarSepIndex;
    private final int fragSepIndex;

    public NestedJarBoot2StringUrl(String urlString, int nestSepIndex, int jarSepIndex) throws URISyntaxException {
        super(urlString);
        int fragmentIdx = urlString.indexOf(35, nestSepIndex);
        this.nestSepIndex = nestSepIndex;
        this.jarSepIndex = jarSepIndex;
        this.fragSepIndex = fragmentIdx != -1 ? fragmentIdx : urlString.length();
    }

    public NestedJarBoot2StringUrl(String urlString) throws URISyntaxException {
        super(urlString);
        if (!CommonsUriInternals.isSchemeUrl(urlString, "jar:file")) {
            throw new IllegalArgumentException("url= " + urlString);
        }
        int jarSep1Idx = urlString.indexOf("!/", 9);
        if (jarSep1Idx == -1) {
            throw new URISyntaxException(urlString, "JAR content separator '!/' is missing");
        }
        int jarSep2Idx = urlString.indexOf("!/", jarSep1Idx + 2);
        if (jarSep2Idx == -1) {
            throw new URISyntaxException(urlString, "Nested JAR separator '!/' is missing");
        }
        int fragmentIdx = urlString.indexOf(35, jarSep2Idx);
        this.nestSepIndex = jarSep1Idx;
        this.jarSepIndex = jarSep2Idx;
        this.fragSepIndex = fragmentIdx != -1 ? fragmentIdx : urlString.length();
    }

    @Override
    public String getOuterArchiveType() {
        return "jar";
    }

    @Override
    protected String createOuterArchiveUrl(String urlString) {
        return urlString.substring(4, this.nestSepIndex);
    }

    @Override
    public String getInnerArchiveType() {
        return "jar";
    }

    @Override
    protected String createInnerArchiveUrl(String urlString) throws URISyntaxException {
        return urlString.substring(0, this.jarSepIndex);
    }

    @Override
    protected String createEntryPath(String urlString) {
        return urlString.substring(this.jarSepIndex + 2, this.fragSepIndex);
    }
}

