/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
class InlinesSubstitution {
    private final Inline first;
    private final Inline last;
    private final ImList<Inline> substitution;

    public InlinesSubstitution(Inline first, Inline last, List<? extends Inline> substitution) {
        this.first = (Inline)ObjectUtils.nonNullAssert((Object)first);
        this.last = (Inline)ObjectUtils.nonNullAssert((Object)last);
        this.substitution = ImCollections.toList(substitution);
    }

    public List<Inline> apply(List<Inline> inlines) {
        ArrayList<Inline> builder = new ArrayList<Inline>();
        boolean inReplacementSegment = false;
        for (Inline inline : inlines) {
            if (inline == this.first) {
                inReplacementSegment = true;
                builder.addAll((Collection<Inline>)this.substitution);
            }
            if (!inReplacementSegment) {
                builder.add(inline);
            }
            if (!inReplacementSegment || inline != this.last) continue;
            inReplacementSegment = false;
        }
        return builder;
    }
}

