/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.texteditor.IUpdate;

public class MultiActionHandler
implements Listener,
ISelectionChangedListener {
    private @Nullable Widget activeWidget;
    private final List<Widget> knownWidgets = new ArrayList<Widget>();
    private final Map<String, ActionWrapper> actions = new HashMap<String, ActionWrapper>();

    MultiActionHandler() {
    }

    private ActionWrapper getActionWrapper(String id) {
        ActionWrapper wrapper = this.actions.get(id);
        if (wrapper == null) {
            wrapper = new ActionWrapper();
            this.actions.put(id, wrapper);
        }
        return wrapper;
    }

    public void addGlobalAction(Widget widget, String globalId, IAction action) {
        if (action.getId() == null) {
            action.setId(globalId);
        }
        ActionWrapper wrapper = this.getActionWrapper(globalId);
        wrapper.widgetActionMap.put(widget, action);
        this.addWidget(widget);
    }

    private void addWidget(Widget widget) {
        if (!this.knownWidgets.contains(widget)) {
            widget.addListener(15, (Listener)this);
            widget.addListener(16, (Listener)this);
            this.knownWidgets.add(widget);
        }
    }

    public void registerActions(IActionBars bars) {
        for (String id : this.actions.keySet()) {
            bars.setGlobalActionHandler(id, (IAction)this.actions.get(id));
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.activeWidget = event.widget;
                this.updateEnabledState();
                break;
            }
            case 16: {
                this.activeWidget = null;
                this.updateEnabledState();
                break;
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateEnabledState();
    }

    void updateEnabledState() {
        for (ActionWrapper wrapper : this.actions.values()) {
            wrapper.update();
        }
    }

    public void dispose() {
        this.activeWidget = null;
        this.actions.clear();
        this.knownWidgets.clear();
    }

    private class ActionWrapper
    extends Action {
        private final Map<Widget, IAction> widgetActionMap = new HashMap<Widget, IAction>();

        ActionWrapper() {
        }

        public void update() {
            IAction action;
            boolean enabled = false;
            if (MultiActionHandler.this.activeWidget != null && (action = this.widgetActionMap.get(MultiActionHandler.this.activeWidget)) != null) {
                if (action instanceof IUpdate) {
                    ((IUpdate)action).update();
                }
                enabled = action.isEnabled();
            }
            this.setEnabled(enabled);
        }

        public void runWithEvent(Event event) {
            IAction action;
            if (MultiActionHandler.this.activeWidget != null && (action = this.widgetActionMap.get(MultiActionHandler.this.activeWidget)) != null) {
                action.runWithEvent(event);
            }
        }
    }
}

