/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.statet.internal.r.debug.core.RDebugCorePlugin;
import org.eclipse.statet.internal.r.debug.core.breakpoints.RControllerBreakpointAdapter;
import org.eclipse.statet.internal.r.debug.core.eval.ExpressionValidator;
import org.eclipse.statet.internal.r.debug.core.model.RDebugElement;
import org.eclipse.statet.internal.r.debug.core.model.RMainThread;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.NullProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.nico.core.runtime.IRemoteEngineController;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.data.RValueFormatter;
import org.eclipse.statet.r.core.data.RValueValidator;
import org.eclipse.statet.r.debug.core.RDebugTarget;
import org.eclipse.statet.r.debug.core.breakpoints.RBreakpoint;
import org.eclipse.statet.r.nico.AbstractRDbgController;
import org.eclipse.statet.rj.server.dbg.DbgFilterState;
import org.eclipse.statet.rj.server.dbg.DbgRequest;

@NonNullByDefault
public class RDebugTargetImpl
extends RDebugElement
implements RDebugTarget,
IStepFilters,
ToolController.IToolStatusListener {
    protected final RProcess process;
    private final AbstractRDbgController controller;
    private final RControllerBreakpointAdapter breakpointAdapter;
    protected final List<IThread> threads = new ArrayList<IThread>(1);
    private @Nullable RMainThread mainThread;
    protected boolean stepFiltersEnabled;
    private @Nullable RValueValidator valueValidator;
    private @Nullable RValueFormatter valueFormatter;
    private @Nullable ExpressionValidator expressionValidator;

    public RDebugTargetImpl(AbstractRDbgController controller) {
        super(null);
        this.controller = controller;
        this.process = controller.getTool();
        this.breakpointAdapter = new RControllerBreakpointAdapter(this, this.controller);
        this.init();
        this.controller.initDebug((AbstractRDbgController.IRControllerTracepointAdapter)this.breakpointAdapter);
    }

    @Override
    public final RDebugTargetImpl getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.process.getLaunch();
    }

    @Override
    public RProcess getProcess() {
        return this.process;
    }

    public String getName() throws DebugException {
        return "R Engine";
    }

    protected void init() {
        this.getLaunch().addDebugTarget((IDebugTarget)this);
        this.fireCreationEvent();
        this.controller.addToolStatusListener((ToolController.IToolStatusListener)this);
        this.breakpointAdapter.init();
        this.initState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerStatusChanged(ToolStatus oldStatus, ToolStatus newStatus, List<DebugEvent> eventCollection) {
        if (newStatus == ToolStatus.TERMINATED) {
            this.breakpointAdapter.dispose();
            eventCollection.add(new DebugEvent((Object)this, 8));
            List<IThread> list = this.threads;
            synchronized (list) {
                if (this.mainThread != null) {
                    this.mainThread.setTerminated();
                    this.mainThread = null;
                }
                this.threads.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initState() {
        List<IThread> list = this.threads;
        synchronized (list) {
            RMainThread thread = this.mainThread = new RMainThread(this, this.controller, "R Main Thread");
            this.threads.add(thread);
            thread.fireCreationEvent();
        }
    }

    public boolean hasThreads() throws DebugException {
        return !this.threads.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull IThread[] getThreads() throws DebugException {
        List<IThread> list = this.threads;
        synchronized (list) {
            return this.threads.toArray(new IThread[this.threads.size()]);
        }
    }

    public boolean isTerminated() {
        return this.process.isTerminated() && !this.isDisconnected();
    }

    public boolean canTerminate() {
        return this.process.canTerminate();
    }

    public void terminate() throws DebugException {
        this.process.terminate();
    }

    public boolean isDisconnected() {
        return this.process.isProvidingFeatureSet("org.eclipse.statet.nico/remote") && ((IRemoteEngineController)this.controller).isDisconnected();
    }

    public boolean canDisconnect() {
        return this.process.isProvidingFeatureSet("org.eclipse.statet.nico/remote") && !this.process.isTerminated();
    }

    public void disconnect() throws DebugException {
        if (this.canDisconnect()) {
            try {
                ((IRemoteEngineController)this.controller).disconnect((ProgressMonitor)new NullProgressMonitor());
            }
            catch (StatusException e) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.statet.nico.core", 5010, e.getMessage(), (Throwable)e));
            }
        }
    }

    protected void exec(DbgRequest request) throws DebugException {
        try {
            this.controller.exec(request);
        }
        catch (StatusException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 5012, "An error occurred when executing debug request in the R engine.", (Throwable)e));
        }
    }

    public boolean isSuspended() {
        RMainThread mainThread = this.mainThread;
        return mainThread != null && mainThread.isSuspended();
    }

    public boolean canSuspend() {
        RMainThread mainThread = this.mainThread;
        return mainThread != null && mainThread.canSuspend();
    }

    public void suspend() throws DebugException {
        RMainThread mainThread = this.mainThread;
        if (mainThread != null) {
            mainThread.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canResume() {
        if (this.isSuspended()) {
            return true;
        }
        List<IThread> list = this.threads;
        synchronized (list) {
            int i = 0;
            while (true) {
                if (i >= this.threads.size()) {
                    return false;
                }
                if (this.threads.get(i).canResume()) {
                    return true;
                }
                ++i;
            }
        }
    }

    public void resume() throws DebugException {
        if (this.canResume()) {
            this.exec((DbgRequest)new DbgRequest.Resume());
        }
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint instanceof RBreakpoint) {
            return this.breakpointAdapter.supportsBreakpoint((RBreakpoint)breakpoint);
        }
        return false;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, @Nullable IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, @Nullable IMarkerDelta delta) {
    }

    public boolean isStepFiltersEnabled() {
        return this.stepFiltersEnabled;
    }

    public boolean supportsStepFilters() {
        return true;
    }

    public void setStepFiltersEnabled(boolean enabled) {
        if (this.process.isTerminated()) {
            return;
        }
        this.stepFiltersEnabled = enabled;
        try {
            this.controller.exec(new DbgFilterState(enabled));
        }
        catch (StatusException e) {
            RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when updating step filters in the R engine.", (Throwable)e));
        }
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public @Nullable IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public synchronized RValueValidator getValueValidator() {
        RValueValidator valueValidator = this.valueValidator;
        if (valueValidator == null) {
            this.valueValidator = valueValidator = new RValueValidator();
        }
        return valueValidator;
    }

    public synchronized RValueFormatter getValueFormatter() {
        RValueFormatter valueFormatter = this.valueFormatter;
        if (valueFormatter == null) {
            this.valueFormatter = valueFormatter = new RValueFormatter();
        }
        return valueFormatter;
    }

    public synchronized ExpressionValidator getExpressionValidator() {
        ExpressionValidator expressionValidator = this.expressionValidator;
        if (expressionValidator == null) {
            this.expressionValidator = expressionValidator = new ExpressionValidator();
        }
        return expressionValidator;
    }
}

