/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.core.sourcelookup;

import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.sourcelookup.RSourceContainer;

@NonNullByDefault
public class RProjectSourceContainer
extends CompositeSourceContainer
implements RSourceContainer {
    public static final String TYPE_ID = "org.eclipse.statet.r.debugSourceContainers.RProjectType";
    private final IProject project;
    private boolean referenced;

    public RProjectSourceContainer(IProject project, boolean referenced) {
        this.project = project;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public String getName() {
        return this.project.getName();
    }

    public boolean isComposite() {
        return this.referenced;
    }

    public IProject getProject() {
        return this.project;
    }

    protected @NonNull ISourceContainer[] createSourceContainers() throws CoreException {
        return new ISourceContainer[0];
    }

    public @NonNull Object[] findSourceElements(String name) throws CoreException {
        return EMPTY;
    }

    public @Nullable IFile findSourceElement(@Nullable URI fileUri, IFile[] fileInWorkspace) {
        if (this.project.isOpen() && this.project.exists()) {
            IFile[] iFileArray = fileInWorkspace;
            int n = fileInWorkspace.length;
            int n2 = 0;
            while (n2 < n) {
                IFile workspaceFile = iFileArray[n2];
                if (this.project.equals((Object)workspaceFile.getProject()) && workspaceFile.exists()) {
                    return workspaceFile;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void findSourceElement(IPath path, List<Object> elements) {
        IFile file;
        if (this.project.isOpen() && this.project.exists() && (file = this.project.getFile(path)).exists()) {
            elements.add(file);
        }
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof RProjectSourceContainer && this.project.equals((Object)((RProjectSourceContainer)obj).project);
    }
}

