/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.dsl.core.source.ast.DslAstVisitor;
import org.eclipse.statet.dsl.core.source.ast.NodeType;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.impl.AbstractAstNode;

@NonNullByDefault
public abstract class DslAstNode
extends AbstractAstNode
implements AstNode {
    protected static final ImIdentityList<DslAstNode> NO_CHILDREN = ImCollections.emptyIdentityList();
    @Nullable DslAstNode dslParent;

    DslAstNode(int statusCode, @Nullable DslAstNode parent) {
        super(statusCode);
        this.dslParent = parent;
    }

    DslAstNode(@Nullable DslAstNode parent) {
        this.dslParent = parent;
    }

    DslAstNode() {
    }

    public abstract NodeType getNodeType();

    public char getOperator() {
        return '\u0000';
    }

    public @Nullable AstNode getParent() {
        return this.dslParent;
    }

    public final @Nullable DslAstNode getDslParent() {
        return this.dslParent;
    }

    public abstract boolean hasChildren();

    public abstract int getChildCount();

    public abstract DslAstNode getChild(int var1);

    public abstract int getChildIndex(AstNode var1);

    public abstract void acceptInDsl(DslAstVisitor var1) throws InvocationTargetException;

    public abstract void acceptInDslChildren(DslAstVisitor var1) throws InvocationTargetException;

    protected void finish(int endOffset) {
        if (this.hasErrorInChild()) {
            this.doSetStatusSeverityInChild(0x4000000);
        }
    }

    protected boolean hasErrorInChild() {
        return false;
    }

    final void setStatus(int statusCode) {
        this.doSetStatusCode(statusCode);
    }

    final void setStatusThis(int statusCode) {
        this.doSetStatusThis(statusCode);
    }

    final void clearStatusSeverityInChild() {
        this.doClearStatusSeverityInChild();
    }

    final void setStatusSeverityInChild(int statusCode) {
        this.doSetStatusSeverityInChild(statusCode);
    }

    final void setStatusSubsequent() {
        this.doAddStatusFlag(0x800000);
    }

    final void setStartOffset(int offset) {
        this.doSetStartOffset(offset);
    }

    final void setEndOffset(int offset) {
        this.doSetEndOffset(offset);
    }

    final void setStartEndOffset(int startOffset, int endOffset) {
        this.doSetStartEndOffset(startOffset, endOffset);
    }

    final void setStartEndOffset(int offset) {
        this.doSetStartEndOffset(offset);
    }

    static void acceptInDsl(DslAstVisitor visitor, @Nullable DslAstNode node) throws InvocationTargetException {
        if (node != null) {
            node.acceptInDsl(visitor);
        }
    }

    protected static final void setStatusThis(DslAstNode node, int statusCode) {
        node.setStatusThis(statusCode);
    }
}

