/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.gr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.statet.rj.server.GDCmdItem;
import org.eclipse.statet.rj.server.RJ;
import org.eclipse.statet.rj.server.gr.RjsGraphic;

public class RjsGraphicManager {
    private static final Comparator<RjsGraphic> GRAPHIC_COMPARATOR = new Comparator<RjsGraphic>(){

        @Override
        public int compare(RjsGraphic o1, RjsGraphic o2) {
            return o1.getDevId() - o2.getDevId();
        }
    };
    private final List<RjsGraphic> graphicList = new ArrayList<RjsGraphic>();
    private RjsGraphic activeGraphic;
    private int inOperation;
    private RjsGraphic inOperationActiveGraphic;
    private final RJ rj;

    public RjsGraphicManager(RJ rj) {
        this.rj = rj;
    }

    void registerGraphic(RjsGraphic graphic) {
        int idx = Collections.binarySearch(this.graphicList, graphic, GRAPHIC_COMPARATOR);
        if (idx >= 0) {
            this.graphicList.set(idx, graphic);
        } else {
            this.graphicList.add(~idx, graphic);
        }
    }

    void unregisterGraphic(RjsGraphic graphic) {
        if (this.activeGraphic == graphic) {
            this.activeGraphic = null;
        }
        if (this.inOperationActiveGraphic == graphic) {
            this.inOperationActiveGraphic = null;
        }
        this.graphicList.remove(graphic);
    }

    void activate(RjsGraphic graphic) {
        this.activeGraphic = graphic;
        if (this.inOperation == 0) {
            this.rj.sendMainCmd(new GDCmdItem.CSetActiveOn(graphic.getDevId(), graphic.getSlot()));
        }
    }

    void deactivate(RjsGraphic graphic) {
        if (this.activeGraphic == graphic) {
            this.activeGraphic = null;
        }
        if (this.inOperation == 0) {
            this.rj.sendMainCmd(new GDCmdItem.CSetActiveOff(graphic.getDevId(), graphic.getSlot()));
        }
    }

    public RjsGraphic getGraphic(int devId) {
        int i = 0;
        while (i < this.graphicList.size()) {
            RjsGraphic graphic = this.graphicList.get(i);
            if (graphic.getDevId() >= devId) {
                if (graphic.getDevId() > devId) break;
                return graphic;
            }
            ++i;
        }
        return null;
    }

    protected void beginOperation() {
        if (this.inOperation == 0) {
            this.inOperationActiveGraphic = this.activeGraphic;
        }
        ++this.inOperation;
    }

    protected void endOperation() {
        --this.inOperation;
        if (this.inOperation == 0) {
            if (this.inOperationActiveGraphic != this.activeGraphic) {
                if (this.inOperationActiveGraphic != null) {
                    this.rj.sendMainCmd(new GDCmdItem.CSetActiveOff(this.inOperationActiveGraphic.getDevId(), this.inOperationActiveGraphic.getSlot()));
                }
                if (this.activeGraphic != null) {
                    this.rj.sendMainCmd(new GDCmdItem.CSetActiveOn(this.activeGraphic.getDevId(), this.activeGraphic.getSlot()));
                }
            }
            this.inOperationActiveGraphic = null;
        }
    }
}

