/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.nico.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.security.SecureRandom;
import java.util.Map;
import org.eclipse.statet.ecommons.net.core.ECommonsNetCore;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.net.core.RSAccessClientSession;
import org.eclipse.statet.jcommons.net.core.RemoteProcess;
import org.eclipse.statet.jcommons.net.core.RemoteTarget;
import org.eclipse.statet.jcommons.net.core.ssh.SshTarget;
import org.eclipse.statet.jcommons.runtime.ProcessConfigBuilder;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.NullProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;
import org.eclipse.statet.rj.server.FxCallback;

@NonNullByDefault
public class RjsUtil {
    public static boolean isRSAccessSupported(ToolCommandData connectionData) {
        String protocol = connectionData.getString("protocol");
        return protocol != null && protocol.equals("ssh");
    }

    public static RemoteTarget getRemoteTarget(ToolCommandData connectionData) throws StatusException {
        String sshHost = connectionData.getStringRequired("ssh.host");
        int sshPort = connectionData.getInt("ssh.port", -1);
        String username = connectionData.getStringRequired("username");
        return new SshTarget(sshHost, sshPort > 0 ? new Port(sshPort) : null, username);
    }

    public static RSAccessClientSession getRSAccessClientSession(RemoteTarget target, ProgressMonitor m) throws StatusException {
        return ECommonsNetCore.getSessionManager().getClientSession(target, m);
    }

    public static @Nullable RSAccessClientSession getRSAccessClientSession(ToolCommandData connectionData, ProgressMonitor m) throws StatusException {
        if (RjsUtil.isRSAccessSupported(connectionData)) {
            return RjsUtil.getRSAccessClientSession(RjsUtil.getRemoteTarget(connectionData), m);
        }
        return null;
    }

    public static RMIClientSocketFactory createRMIOverSshClientSocketFactory(final RSAccessClientSession session) {
        return new RMIClientSocketFactory(){

            @Override
            public Socket createSocket(@Nullable String host, int port) throws IOException {
                NullProgressMonitor m = new NullProgressMonitor();
                try {
                    return session.createDirectTcpIpSocket(new Port(port), (ProgressMonitor)m);
                }
                catch (StatusException e) {
                    IOException ioException = new IOException();
                    ioException.initCause(e);
                    throw ioException;
                }
            }
        };
    }

    public static void startRemoteServerOverSsh(RSAccessClientSession session, String command, Map<String, String> envVars, ProgressMonitor m) throws StatusException {
        m.setWorkRemaining(5);
        Throwable error = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (RemoteProcess remoteProcess = session.exec(new ProcessConfigBuilder().setCommandString(command).addEnvironmentVars(envVars).setOutputStream((OutputStream)output).build(), m.newSubMonitor(2));){
                int statusCode = remoteProcess.waitFor(null, m.newSubMonitor(2));
                if (statusCode != 0) {
                    ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("Remote process has exit with an error:");
                    sb.addProp("ExitStatusCode", statusCode);
                    sb.addProp("Message", output.toString(StandardCharsets.UTF_8));
                    error = new RemoteException(sb.toString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (StatusException e) {
            error = e;
        }
        if (error != null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", "Failed to start remote R server over SSH.", error));
        }
    }

    public static void handleFxCallback(RSAccessClientSession session, FxCallback callback, ProgressMonitor m) throws StatusException {
        byte[] clientKey = new byte[1024];
        new SecureRandom().nextBytes(clientKey);
        String filename = callback.getFilename();
        byte[] content = callback.createContent(clientKey);
        Throwable error = null;
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (RemoteProcess remoteProcess = session.exec(new ProcessConfigBuilder().setCommandString("cat >> " + filename).setInputStream((InputStream)new ByteArrayInputStream(content)).build(), m.newSubMonitor(1));){
                int statusCode = remoteProcess.waitFor(null, m.newSubMonitor(1));
                if (statusCode != 0) {
                    ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("Remote process has exit with an error:");
                    sb.addProp("ExitStatusCode", statusCode);
                    error = new RemoteException(sb.toString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (StatusException e) {
            error = e;
        }
        if (error != null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", "Failed to authenticate over SSH connection.", error));
        }
    }

    public static String getVersionString(int @Nullable [] version) {
        if (version == null) {
            return "no version information";
        }
        if (version.length >= 3) {
            StringBuilder sb = new StringBuilder();
            sb.append(version[0]);
            sb.append('.');
            sb.append(version[1] >= 0 ? Integer.toString(version[1]) : "x");
            sb.append('.');
            sb.append(version[2] >= 0 ? Integer.toString(version[2]) : "x");
            return sb.toString();
        }
        return "invalid version information";
    }
}

