/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.Instant;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.eclipse.statet.internal.rj.servi.MXNodeState;
import org.eclipse.statet.internal.rj.servi.NodeHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.servi.jmx.NodeMXBean;
import org.eclipse.statet.rj.servi.jmx.NodeStateMX;
import org.eclipse.statet.rj.servi.pool.PoolConfig;
import org.eclipse.statet.rj.servi.pool.PoolNodeItem;
import org.eclipse.statet.rj.servi.pool.PoolNodeObject;
import org.eclipse.statet.rj.servi.pool.PoolServer;

@NonNullByDefault
public class MXNode
implements NodeMXBean {
    private final PoolServer server;
    private final PoolNodeObject nodeObj;
    private final RMIAddress address;
    private final Instant creationTime;
    private @Nullable ObjectName jmName;

    public MXNode(PoolServer server, PoolNodeObject nodeObj) {
        this.server = server;
        this.nodeObj = nodeObj;
        NodeHandler nodeHandler = (NodeHandler)ObjectUtils.nonNullAssert((Object)this.nodeObj.getNodeHandler());
        this.address = (RMIAddress)ObjectUtils.nonNullAssert((Object)nodeHandler.getAddress());
        this.creationTime = this.nodeObj.getCreationTime();
    }

    public void initJM() throws JMException {
        ObjectName jmName;
        this.jmName = jmName = new ObjectName(this.server.getJMBaseName() + "type=Server.Node,rservi.nodeId=" + this.address.getName());
        ManagementFactory.getPlatformMBeanServer().registerMBean(this, jmName);
    }

    public void disposeJM() throws JMException {
        ObjectName jmName = this.jmName;
        if (jmName != null) {
            this.jmName = null;
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(jmName);
        }
    }

    @Override
    public String getId() {
        return this.address.getName();
    }

    @Override
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Override
    public NodeStateMX getState() {
        PoolNodeItem item = new PoolNodeItem(this.nodeObj, Instant.now());
        return new MXNodeState(item);
    }

    @Override
    public boolean isConsoleEnabled() {
        NodeHandler nodeHandler = this.nodeObj.getNodeHandler();
        return nodeHandler != null && nodeHandler.isConsoleEnabled();
    }

    @Override
    public synchronized void setConsoleEnabled(boolean enable) throws OperationsException {
        try {
            NodeHandler nodeHandler = this.nodeObj.getNodeHandler();
            if (nodeHandler == null) {
                throw new UnsupportedOperationException("not available");
            }
            if (enable) {
                nodeHandler.enableConsole("none");
            } else {
                nodeHandler.disableConsole();
            }
        }
        catch (RjException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    @Override
    public void stop() throws OperationsException {
        PoolConfig config = new PoolConfig();
        this.server.getPoolConfig(config);
        this.nodeObj.evict(config.getEvictionTimeout());
    }

    @Override
    public void stop(long timeoutMillis) throws OperationsException {
        if (timeoutMillis < 0L) {
            throw new OperationsException("Invalid parameter 'timeoutMillis' >= 0.");
        }
        this.nodeObj.evict(Duration.ofMillis(timeoutMillis));
    }

    @Override
    public void kill() throws OperationsException {
        this.nodeObj.evict(null);
    }
}

