/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature.wizards;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.eutils.autonature.Task;
import org.eclipse.statet.internal.eutils.autonature.wizards.ConfigureProjectWizard;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
public class ConfigureProjectWizardPage
extends WizardPage
implements ICheckStateListener {
    private final IProject project;
    private final Collection<Task> editableTasks = new HashSet<Task>();
    private final HashSet<Task> alreadyConfigTasks = new HashSet();
    private final HashSet<Task> toConfigTasks = new HashSet();
    private ViewerUtils.TableComposite configTable = (ViewerUtils.TableComposite)ObjectUtils.nonNullLateInit();
    private ViewerUtils.CheckboxColumnControl<Task> configTableEnabledColumn = (ViewerUtils.CheckboxColumnControl)ObjectUtils.nonNullLateInit();
    private Button deselectButton = (Button)ObjectUtils.nonNullLateInit();

    public ConfigureProjectWizardPage(IProject project) {
        super("AutoConfigureProject");
        this.project = project;
        this.setTitle(NLS.bind((String)"Configure project ''{0}''", (Object)project.getName()));
        this.setDescription("Select the project configurations to apply.");
    }

    public void createControl(Composite parent) {
        ViewerUtils.TableComposite tableComposite;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newContentGrid((int)2));
        this.configTable = tableComposite = new ViewerUtils.TableComposite(composite, 68096);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        Dialog.applyDialogFont((Control)tableComposite);
        gd.heightHint = tableComposite.table.getItemHeight() * 10;
        tableComposite.setLayoutData((Object)gd);
        tableComposite.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn column = new TableViewerColumn(tableComposite.viewer, 0x1000000);
        this.configTableEnabledColumn = new ViewerUtils.CheckboxColumnControl<Task>(tableComposite.viewer, this.toConfigTasks, this.editableTasks){

            public boolean getChecked(Object element) {
                return ConfigureProjectWizardPage.this.alreadyConfigTasks.contains(element) || super.getChecked(element);
            }
        };
        column.setLabelProvider(this.configTableEnabledColumn);
        this.configTableEnabledColumn.configureAsMainColumn();
        tableComposite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(this.configTableEnabledColumn.hintColumnWidth(), false, true));
        this.configTableEnabledColumn.addCheckStateListener((ICheckStateListener)this);
        column = tableComposite.addColumn("Project Configuration", 16384, (ColumnLayoutData)new ColumnWeightData(5, true));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Task task = (Task)cell.getElement();
                cell.setText(task.getLabel());
            }
        });
        Button button = new Button(composite, 8);
        button.setText("&Deselect All");
        gd = new GridData(4, 128, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Button)button);
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureProjectWizardPage.this.toConfigTasks.clear();
                ConfigureProjectWizardPage.this.configTable.viewer.update(ConfigureProjectWizardPage.this.editableTasks.toArray(), null);
                ConfigureProjectWizardPage.this.updateState();
            }
        });
        this.deselectButton = button;
        this.setControl((Control)composite);
        this.resetInput();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.configTable.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((ConfigureProjectWizard)ConfigureProjectWizardPage.this.getWizard()).runInit();
            }
        });
    }

    public void resetInput() {
        this.configTable.table.setEnabled(false);
        this.configTable.viewer.setInput((Object)Collections.EMPTY_LIST);
        this.deselectButton.setEnabled(false);
        this.editableTasks.clear();
        this.toConfigTasks.clear();
        this.updateState();
    }

    public void setInput(List<Task> allTasks, List<Task> alreadyConfigTasks, List<Task> recommendTasks) {
        for (Task task : allTasks) {
            if (alreadyConfigTasks.contains(task)) continue;
            this.editableTasks.add(task);
        }
        this.alreadyConfigTasks.addAll(alreadyConfigTasks);
        this.toConfigTasks.addAll(recommendTasks);
        this.configTable.viewer.setInput(allTasks);
        this.configTable.table.setEnabled(true);
        this.updateState();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.updateState();
    }

    private void updateState() {
        this.deselectButton.setEnabled(!this.toConfigTasks.isEmpty());
        this.getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        return !this.toConfigTasks.isEmpty();
    }

    public Collection<Task> getConfigTasks() {
        return this.toConfigTasks;
    }
}

