/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIntList;
import org.eclipse.statet.jcommons.lang.Immutable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.util.Version;

@NonNullByDefault
public final class RNumVersion
implements Immutable,
Comparable<RNumVersion> {
    public static final RNumVersion NONE = new RNumVersion("", ImCollections.emptyIntList());
    private final String string;
    private volatile @Nullable ImIntList nums;
    private volatile int numsEndIndex;

    public static RNumVersion create(String s) {
        if (s == null || s.isEmpty()) {
            return NONE;
        }
        return new RNumVersion(s);
    }

    public static RNumVersion create(String s, boolean checkValid) {
        RNumVersion version = RNumVersion.create(s);
        if (checkValid && !version.isValid()) {
            throw new IllegalArgumentException();
        }
        return version;
    }

    private RNumVersion(String s, ImIntList nums) {
        this.string = s;
        this.nums = nums;
    }

    private RNumVersion(String s) {
        this.string = s;
    }

    public ImIntList getNums() {
        ImIntList nums = this.nums;
        if (nums == null) {
            int[] v = new int[(1 + this.string.length()) / 2];
            int numIdx = 0;
            int idx = 0;
            int numStartIndex = 0;
            int numEndIndex = 0;
            block4: while (true) {
                switch (this.string.charAt(idx)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (++idx < this.string.length()) continue block4;
                        int n = numIdx++;
                        numEndIndex = idx;
                        v[n] = Integer.parseInt(this.string, numStartIndex, numEndIndex, 10);
                        break block4;
                    }
                    case '-': 
                    case '.': {
                        if (idx <= numStartIndex) break block4;
                        int n = numIdx++;
                        numEndIndex = idx++;
                        v[n] = Integer.parseInt(this.string, numStartIndex, numEndIndex, 10);
                        if (idx >= this.string.length()) break block4;
                        numStartIndex = idx;
                        continue block4;
                    }
                    default: {
                        idx = numStartIndex;
                        break block4;
                    }
                }
                break;
            }
            while (numIdx > 0 && v[numIdx - 1] == 0) {
                --numIdx;
            }
            this.nums = nums = ImCollections.newIntList((int[])v, (int)0, (int)numIdx);
            this.numsEndIndex = numEndIndex;
        }
        return nums;
    }

    public boolean isValid() {
        this.getNums();
        return this.numsEndIndex > 0 && this.numsEndIndex == this.string.length();
    }

    public Version toVersion(boolean withQualifier) {
        if (withQualifier) {
            throw new UnsupportedOperationException("TODO");
        }
        ImIntList nums = this.getNums();
        return switch (nums.size()) {
            case 0 -> new Version(0, 0);
            case 1 -> new Version(nums.getAt(0), 0);
            case 2 -> new Version(nums.getAt(0), nums.getAt(1));
            default -> new Version(nums.getAt(0), nums.getAt(1), nums.getAt(2));
        };
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof RNumVersion && this.string.equals(((RNumVersion)obj).string);
    }

    @Override
    public int compareTo(RNumVersion other) {
        return RNumVersion.compare(this.getNums(), other.getNums());
    }

    public String toString() {
        return this.string;
    }

    static int compare(ImIntList v1, ImIntList v2) {
        int l = Math.min(v1.size(), v2.size());
        int i = 0;
        while (i < l) {
            int diff = v1.getAt(i) - v2.getAt(i);
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        return v1.size() - v2.size();
    }
}

