/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors.rpkg;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceObjectDef;
import org.eclipse.statet.ecommons.preferences.core.PreferenceUtils;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.text.ui.assist.LinkedModeBracketLevel;
import org.eclipse.statet.internal.r.ui.editors.rpkg.RPkgDescrBracketLevel;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.string.CharPair;
import org.eclipse.statet.jcommons.string.Chars;
import org.eclipse.statet.jcommons.text.core.CharPairSet;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractAutoEditStrategy;
import org.eclipse.statet.ltk.ui.sourceediting.SmartInsertSettings;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.core.source.doc.RPkgDescrPartitionNodeType;
import org.eclipse.statet.r.core.source.util.RPkgDescrHeuristicTokenScanner;
import org.eclipse.statet.r.ui.editors.REditorOptions;
import org.eclipse.swt.events.KeyEvent;

public class RPkgDescrAutoEditStrategy
extends AbstractAutoEditStrategy {
    private static final PreferenceObjectDef<Config> CONFIG_PREF_FACTORY = PreferenceObjectDef.createFactory(Config.class, (ImSet)ImCollections.newSet((Object)"org.eclipse.statet.r.ui/editor.r/options"), Config::new);
    private final RCoreAccess rCoreAccess;
    private Config settings;
    private RPkgDescrHeuristicTokenScanner scanner;
    private RCodeStyleSettings rCodeStyle;

    public RPkgDescrAutoEditStrategy(RCoreAccess coreAccess, SourceEditor editor) {
        super(editor);
        assert (coreAccess != null);
        this.rCoreAccess = coreAccess;
    }

    public Config getSettings() {
        return this.settings;
    }

    protected IIndentSettings getCodeStyleSettings() {
        return this.rCodeStyle;
    }

    protected final TreePartition initCustomization(int offset, int ch) throws BadLocationException, BadPartitioningException {
        if (this.scanner == null) {
            this.scanner = this.createScanner();
        }
        this.settings = (Config)PreferenceUtils.getPreferenceObject((PreferenceAccess)this.rCoreAccess.getPrefs(), CONFIG_PREF_FACTORY);
        this.rCodeStyle = this.rCoreAccess.getRCodeStyle();
        return super.initCustomization(offset, ch);
    }

    protected RPkgDescrHeuristicTokenScanner createScanner() {
        return new RPkgDescrHeuristicTokenScanner(this.getDocumentContentInfo());
    }

    /*
     * Unable to fully structure code
     */
    protected TextRegion computeValidRange(int offset, TreePartition partition, int ch) {
        block1: {
            node = partition.getTreeNode();
            if (!(node.getType() instanceof RPkgDescrPartitionNodeType)) break block1;
            if (this.getDocumentContentInfo().getPrimaryType() != "org.eclipse.statet.RPkgDescription") ** GOTO lbl6
            return super.computeValidRange(offset, partition, ch);
lbl-1000:
            // 1 sources

            {
                node = parent;
lbl6:
                // 2 sources

                ** while ((parent = node.getParent()) != null && parent instanceof RPkgDescrPartitionNodeType)
            }
lbl7:
            // 1 sources

            return node;
        }
        return null;
    }

    protected RPkgDescrHeuristicTokenScanner getScanner() {
        return this.scanner;
    }

    protected final void quitCustomization() {
        super.quitCustomization();
        this.rCodeStyle = null;
    }

    private final boolean isClosedBracket(int backwardOffset, int forwardOffset, TextRegion region, CharPair searchType) throws BadLocationException {
        CharPairSet brackets = RPkgDescrHeuristicTokenScanner.DESCR_TEXT_BRACKETS;
        int searchPairIndex = brackets.getPairIndex(searchType);
        int[] balance = new int[brackets.getPairCount()];
        int n = searchPairIndex;
        balance[n] = balance[n] + 1;
        this.scanner.configure((IDocument)this.getDocument());
        balance = this.scanner.computePairBalance(backwardOffset, forwardOffset, region, brackets, balance, searchPairIndex);
        return balance[searchPairIndex] <= 0;
    }

    protected char isCustomizeKey(KeyEvent event) {
        switch (event.character) {
            case '(': 
            case '[': 
            case '{': {
                return event.character;
            }
            case '\t': {
                if (event.stateMask != 0) break;
                return '\t';
            }
            case '\n': 
            case '\r': {
                if (this.getEditor3() == null) break;
                return '\n';
            }
        }
        return '\u0000';
    }

    protected void doCustomizeKeyCommand(char ch, DocumentCommand command, TreePartition partition) throws Exception {
        String contentType = partition.getType();
        int cEnd = command.offset + command.length;
        int linkedModeType = -1;
        int linkedModeOffset = -1;
        switch (ch) {
            case '\t': {
                if (RDocumentConstants.RPKG_DESCR_ANY_CONTENT_CONSTRAINT.matches(contentType) && this.isRegularTabCommand(command)) {
                    command.text = "\t";
                    this.smartInsertOnTab(command, true);
                    break;
                }
                return;
            }
            case '{': {
                if (RDocumentConstants.RPKG_DESCR_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                    command.text = "{";
                    if (!this.settings.closeBrackets) break;
                    if (!this.isClosedBracket(command.offset, cEnd, (TextRegion)partition, Chars.CURLY_BRACKETS)) {
                        command.text = "{}";
                        linkedModeType = 0x1000002;
                        break;
                    }
                    if (this.getChar(cEnd) != 125) break;
                    linkedModeType = 2;
                    break;
                }
                return;
            }
            case '[': {
                if (RDocumentConstants.RPKG_DESCR_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                    command.text = "[";
                    if (!this.settings.closeBrackets) break;
                    if (!this.isClosedBracket(command.offset, cEnd, (TextRegion)partition, Chars.SQUARE_BRACKETS)) {
                        command.text = "[]";
                        linkedModeType = 0x1000002;
                        break;
                    }
                    if (this.getChar(cEnd) != 93) break;
                    linkedModeType = 2;
                    break;
                }
                return;
            }
            case '(': {
                if (RDocumentConstants.RPKG_DESCR_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                    command.text = "(";
                    if (!this.settings.closeBrackets) break;
                    if (!this.isClosedBracket(command.offset, cEnd, (TextRegion)partition, Chars.ROUND_BRACKETS)) {
                        command.text = "()";
                        linkedModeType = 0x1000002;
                        break;
                    }
                    if (this.getChar(cEnd) != 41) break;
                    linkedModeType = 2;
                    break;
                }
                return;
            }
            case '\n': {
                if (RDocumentConstants.RPKG_DESCR_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                    command.text = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument());
                    this.smartIndentOnNewLine(command, contentType);
                    break;
                }
                return;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (command.doit && command.text.length() > 0 && this.getEditor().isEditable(true)) {
            this.getViewer().getTextWidget().setRedraw(false);
            try {
                this.applyCommand(command);
                this.updateSelection(command);
                if (linkedModeType >= 0) {
                    if (linkedModeOffset < 0) {
                        linkedModeOffset = command.offset;
                    }
                    this.createLinkedMode(linkedModeOffset, ch, linkedModeType).enter();
                }
            }
            finally {
                this.getViewer().getTextWidget().setRedraw(true);
            }
        }
    }

    protected void doCustomizeOtherCommand(DocumentCommand command, TreePartition partition) throws Exception {
        String contentType = partition.getType();
        if (RDocumentConstants.RPKG_DESCR_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && command.length == 0 && TextUtilities.equals((String[])this.getDocument().getLegalLineDelimiters(), (String)command.text) != -1) {
            this.smartIndentOnNewLine(command, contentType);
        }
    }

    private void smartIndentOnNewLine(DocumentCommand command, String partitionType) throws Exception {
        String lineDelimiter = command.text;
        this.smartIndentAfterNewLine1(command, lineDelimiter);
    }

    private void smartIndentAfterNewLine1(DocumentCommand command, String lineDelimiter) throws BadLocationException, BadPartitioningException, CoreException {
        AbstractDocument doc = this.getDocument();
        StringBuilder sb = new StringBuilder(command.text);
        int nlIndex = lineDelimiter.length();
        int line = doc.getLineOfOffset(command.offset);
        int checkOffset = Math.max(0, command.offset);
        ITypedRegion partition = doc.getPartition(this.scanner.getDocumentPartitioning(), checkOffset, true);
        IndentUtil util = new IndentUtil((IDocument)doc, (IIndentSettings)this.rCodeStyle);
        int column = util.getLineIndent(line, false)[0];
        if (nlIndex <= sb.length()) {
            sb.insert(nlIndex, util.createIndentString(column));
        }
        command.text = sb.toString();
    }

    private LinkedModeUI createLinkedMode(int offset, char type, int mode) throws BadLocationException {
        LinkedModeModel model = new LinkedModeModel();
        int pos = 0;
        LinkedPositionGroup group = new LinkedPositionGroup();
        LinkedModeBracketLevel.InBracketPosition position = RPkgDescrBracketLevel.createPosition(type, (IDocument)this.getDocument(), offset + 1, 0, pos++);
        group.addPosition((LinkedPosition)position);
        model.addGroup(group);
        model.forceInstall();
        RPkgDescrBracketLevel level = new RPkgDescrBracketLevel(model, (IDocument)this.getDocument(), this.getDocumentContentInfo(), (List<? extends LinkedPosition>)ImCollections.newList((Object)position), mode & 0xFFFF0000);
        LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)this.getViewer());
        ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
        ui.setExitPosition((ITextViewer)this.getViewer(), offset + (mode & 0xFF), 0, pos);
        ui.setSimpleMode(true);
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)level);
        return ui;
    }

    public static class Config
    implements SmartInsertSettings {
        private final boolean enabledByDefault;
        private final SmartInsertSettings.TabAction tabAction;
        private final boolean closeBrackets;

        public Config(PreferenceAccess prefs) {
            this.enabledByDefault = (Boolean)prefs.getPreferenceValue((Preference)REditorOptions.SMARTINSERT_BYDEFAULT_ENABLED_PREF);
            this.tabAction = (SmartInsertSettings.TabAction)prefs.getPreferenceValue(REditorOptions.SMARTINSERT_TAB_ACTION_PREF);
            this.closeBrackets = true;
        }

        public boolean isSmartInsertEnabledByDefault() {
            return this.enabledByDefault;
        }

        public SmartInsertSettings.TabAction getSmartInsertTabAction() {
            return this.tabAction;
        }
    }
}

