/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.statet.ecommons.ui.swt.util.ColorUtils;
import org.eclipse.statet.ecommons.ui.workbench.css.StylingUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

@NonNullByDefault
public class RHelpWorkbenchStyle {
    static final String DOC_BACKGROUND_COLOR_KEY = "org.eclipse.statet.workbench.themes.DocViewBackgroundColor";
    static final String DOC_FOREGROUND_COLOR_KEY = "org.eclipse.statet.workbench.themes.DocViewColor";
    static final String DOC_FONT_KEY = "org.eclipse.statet.workbench.themes.DocViewFont";
    private static final String[] DEFAULT_MATCH_COLORS = new String[]{".SMATCH-A { background: #ceccf7; }\n", ".SMATCH-B { background: #ffffcf; }\n", ".SMATCH-C { background: aquamarine; }\n", ".SMATCH-D { background: palegreen; }\n", ".SMATCH-E { background: coral; }\n", ".SMATCH-F { background: wheat; }\n", ".SMATCH-G { background: khaki; }\n", ".SMATCH-H { background: lime; }\n", ".SMATCH-I { background: deepskyblue; }\n", ".SMATCH-J { background: plum; }\n"};
    private final boolean isThemeStylingRequired;
    private final FontDescriptor dialogFontDescr;
    private RGB dialogBackgroundColor;
    private RGB dialogForegroundColor;
    private RGB buttonBackgroundColor;
    private RGB buttonForegroundColor;
    private RGB borderColor;
    private RGB selectionBackgroundColor;
    private RGB scrollbarBackgroundColor;
    private RGB scrollbarForegroundColor;
    private RGB scrollbarArrowColor;
    private final FontDescriptor docFontDescr;
    private final RGB docBackgroundColor;
    private final RGB docForegroundColor;

    static Color getDocBackgroundColor() {
        return (Color)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().get(DOC_BACKGROUND_COLOR_KEY));
    }

    static Color getDocForegroundColor() {
        return (Color)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().get(DOC_FOREGROUND_COLOR_KEY));
    }

    static StringBuilder appendCssColor(StringBuilder sb, RGB color) {
        sb.append('#');
        String s = Integer.toHexString(color.red);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
        s = Integer.toHexString(color.green);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
        s = Integer.toHexString(color.blue);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
        return sb;
    }

    public RHelpWorkbenchStyle() {
        Display display = (Display)ObjectUtils.nonNullAssert((Object)Display.getCurrent());
        this.isThemeStylingRequired = StylingUtils.isStylingSupported() && !StylingUtils.isCurrentThemeMatchingSystem((Display)display);
        this.dialogFontDescr = (FontDescriptor)ObjectUtils.nonNullAssert((Object)JFaceResources.getDialogFontDescriptor());
        Shell shell = new Shell(display);
        try {
            ScrolledComposite composite = new ScrolledComposite((Composite)shell, 512);
            Button button = new Button((Composite)composite, 8);
            if (this.isThemeStylingRequired) {
                IStylingEngine stylingEngine = StylingUtils.getStylingEngine();
                stylingEngine.style((Object)composite);
            }
            this.dialogBackgroundColor = composite.getBackground().getRGB();
            this.dialogForegroundColor = composite.getForeground().getRGB();
            this.buttonBackgroundColor = button.getBackground().getRGB();
            this.buttonForegroundColor = button.getForeground().getRGB();
            this.borderColor = display.getSystemColor(23).getRGB();
            this.selectionBackgroundColor = display.getSystemColor(26).getRGB();
        }
        finally {
            shell.dispose();
        }
        if (this.isThemeStylingRequired) {
            switch (StylingUtils.getCurrentThemeType((Display)display)) {
                case DARK: {
                    this.scrollbarBackgroundColor = new RGB(23, 23, 23);
                    this.scrollbarForegroundColor = new RGB(77, 77, 77);
                    this.scrollbarArrowColor = new RGB(103, 103, 103);
                    break;
                }
                default: {
                    this.scrollbarBackgroundColor = this.dialogBackgroundColor;
                    this.scrollbarForegroundColor = ColorUtils.blend((RGB)this.dialogForegroundColor, (RGB)this.dialogBackgroundColor, (float)0.15f);
                    this.scrollbarArrowColor = ColorUtils.blend((RGB)this.dialogForegroundColor, (RGB)this.dialogBackgroundColor, (float)0.5f);
                }
            }
        }
        this.docFontDescr = (FontDescriptor)ObjectUtils.nonNullAssert((Object)JFaceResources.getFontDescriptor((String)DOC_FONT_KEY));
        this.docBackgroundColor = (RGB)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().getRGB(DOC_BACKGROUND_COLOR_KEY));
        this.docForegroundColor = (RGB)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().getRGB(DOC_FOREGROUND_COLOR_KEY));
    }

    public FontDescriptor getDialogFontDescr() {
        return this.dialogFontDescr;
    }

    public FontDescriptor getDocFontDescr() {
        return this.docFontDescr;
    }

    public RGB getDocBackgroundColorRGB() {
        return this.docBackgroundColor;
    }

    public RGB getDocForegroundColorRGB() {
        return this.docForegroundColor;
    }

    public RGB getDocBorderColorRGB() {
        return this.borderColor;
    }

    public void appendLinkDefinitions(StringBuilder sb) {
        RGB hyperlinkColor = (RGB)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().getRGB("HYPERLINK_COLOR"));
        RGB hyperlinkActiveColor = (RGB)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().getRGB("ACTIVE_HYPERLINK_COLOR"));
        sb.append("a { color: ");
        RHelpWorkbenchStyle.appendCssColor(sb, hyperlinkColor);
        sb.append("; }\n");
        sb.append("a:hover, a:active, a:focus { color: ");
        RHelpWorkbenchStyle.appendCssColor(sb, hyperlinkActiveColor);
        sb.append("; }\n");
        sb.append("a:visited { color: ");
        RHelpWorkbenchStyle.appendCssColor(sb, new RGB(hyperlinkColor.red + (hyperlinkColor.red <= 127 ? 64 : -64), (hyperlinkColor.green + this.docForegroundColor.green) / 2, (hyperlinkColor.blue + (hyperlinkColor.blue > 32 ? -32 : 32) + this.docForegroundColor.blue) / 2));
        sb.append("; }\n");
    }

    void appendMatchColors(StringBuilder sb) {
        int i = 0;
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)EditorsPlugin.getDefault().getPreferenceStore(), (String)"searchResultIndicationColor");
        if (rgb != null) {
            sb.append(".SMATCH-A { background: ");
            RHelpWorkbenchStyle.appendCssColor(sb, rgb);
            sb.append("; }\n");
            ++i;
        }
        while (i < DEFAULT_MATCH_COLORS.length) {
            sb.append(DEFAULT_MATCH_COLORS[i++]);
        }
    }

    void appendRootColors(StringBuilder sb) {
        sb.append("color: ");
        RHelpWorkbenchStyle.appendCssColor(sb, this.docForegroundColor).append("; ");
        if (this.isThemeStylingRequired) {
            sb.append("scrollbar-color: ");
            RHelpWorkbenchStyle.appendCssColor(sb, this.scrollbarForegroundColor).append(" ");
            RHelpWorkbenchStyle.appendCssColor(sb, this.scrollbarBackgroundColor).append(" ;");
            sb.append("scrollbar-track-color: ");
            RHelpWorkbenchStyle.appendCssColor(sb, this.scrollbarBackgroundColor).append("; ");
            sb.append("scrollbar-base-color: ");
            RHelpWorkbenchStyle.appendCssColor(sb, this.scrollbarBackgroundColor).append("; ");
            sb.append("scrollbar-face-color: ");
            RHelpWorkbenchStyle.appendCssColor(sb, this.scrollbarForegroundColor).append("; ");
            sb.append("scrollbar-arrow-color: ");
            RHelpWorkbenchStyle.appendCssColor(sb, this.scrollbarArrowColor).append("; ");
        }
    }

    void appendScreenColors(StringBuilder sb) {
        sb.append("color: ");
        RHelpWorkbenchStyle.appendCssColor(sb, this.docForegroundColor).append("; ");
        sb.append("background: ");
        RHelpWorkbenchStyle.appendCssColor(sb, this.docBackgroundColor).append("; ");
    }

    void appendDialogColors(StringBuilder sb) {
        sb.append("background: ");
        RHelpWorkbenchStyle.appendCssColor(sb, this.dialogBackgroundColor).append("; ");
        sb.append("color: ");
        RHelpWorkbenchStyle.appendCssColor(sb, this.dialogForegroundColor).append("; ");
    }

    void appendDialogButtonDefinitions(StringBuilder sb) {
        sb.append("button { ");
        this.appendFont(sb, this.dialogFontDescr);
        sb.append("padding: 1px 4px 2px; border: 1px solid ");
        RHelpWorkbenchStyle.appendCssColor(sb, this.borderColor).append("; ");
        sb.append("background: ");
        RHelpWorkbenchStyle.appendCssColor(sb, this.buttonBackgroundColor).append("; ");
        sb.append("color: ");
        RHelpWorkbenchStyle.appendCssColor(sb, this.buttonForegroundColor).append("; ");
        sb.append("}\n");
        sb.append("button:hover { border-color: ");
        RHelpWorkbenchStyle.appendCssColor(sb, ColorUtils.blend((RGB)this.borderColor, (RGB)this.selectionBackgroundColor, (float)0.8f)).append("; ");
        sb.append("background: ");
        RHelpWorkbenchStyle.appendCssColor(sb, ColorUtils.blend((RGB)this.buttonBackgroundColor, (RGB)this.selectionBackgroundColor, (float)0.9f)).append("; ");
        sb.append("}\n");
    }

    void appendFont(StringBuilder sb, FontDescriptor fontDescription) {
        FontData fontData = fontDescription.getFontData()[0];
        sb.append("font-family: '").append(fontData.getName()).append("'; ");
        sb.append("font-size: ").append(fontData.getHeight()).append("pt; ");
    }
}

