/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.editors;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.presentation.SingleTokenScanner;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.ecommons.text.ui.settings.PreferenceStoreTextStyleManager;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.ltk.text.core.CharPairMatcher;
import org.eclipse.statet.ltk.ui.LtkUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.presentation.CommentScanner;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.core.source.doc.RdDocumentContentInfo;
import org.eclipse.statet.r.core.source.util.RdBracketPairMatcher;
import org.eclipse.statet.r.ui.text.rd.RdCodeScanner;
import org.eclipse.statet.r.ui.text.rd.RdDoubleClickStrategy;

public class RdSourceViewerConfiguration
extends SourceEditorViewerConfiguration
implements ISettingsChangedHandler {
    private static final String[] CONTENT_TYPES = (String[])RDocumentConstants.RDOC_CONTENT_TYPES.toArray((Object[])new String[RDocumentConstants.RDOC_CONTENT_TYPES.size()]);
    private final RdDoubleClickStrategy fDoubleClickStrategy;
    private RCoreAccess fRCoreAccess;

    public RdSourceViewerConfiguration(int flags) {
        this(flags, null, null, null, null);
    }

    public RdSourceViewerConfiguration(int flags, SourceEditor sourceEditor, RCoreAccess access, IPreferenceStore preferenceStore, PreferenceStoreTextStyleManager<TextAttribute> textStyles) {
        super((DocContentSections)RdDocumentContentInfo.INSTANCE, flags, sourceEditor);
        this.setCoreAccess(access);
        this.setup(preferenceStore != null ? preferenceStore : RUIPlugin.getInstance().getEditorPreferenceStore(), LtkUIPreferences.getEditorDecorationPreferences(), LtkUIPreferences.getAssistPreferences());
        this.setTextStyles(textStyles);
        this.fDoubleClickStrategy = new RdDoubleClickStrategy();
    }

    protected void setCoreAccess(RCoreAccess access) {
        this.fRCoreAccess = access != null ? access : RCore.getWorkbenchAccess();
    }

    protected void initTextStyles() {
        this.setTextStyles(RUIPlugin.getInstance().getRdTextStyles());
    }

    protected void initScanners() {
        TextStyleManager textStyles = this.getTextStyles();
        this.addScanner("__dftl_partition_content_type", (ITokenScanner)new RdCodeScanner(textStyles));
        this.addScanner("Rd.Comment", (ITokenScanner)new CommentScanner(textStyles, "text_Rd_rdComment", "text_Rd_taskTag", this.fRCoreAccess.getPrefs()));
        this.addScanner("Rd.PlatformSpec", (ITokenScanner)new SingleTokenScanner(textStyles, "text_Rd_rdPlatformSpecif"));
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    public CharPairMatcher getPairMatcher() {
        return new RdBracketPairMatcher(this.getDocumentContentInfo());
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return this.fDoubleClickStrategy;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"%", ""};
    }

    protected ContentAssist createContentAssistant(ISourceViewer sourceViewer) {
        return null;
    }
}

