/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.nostart;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.statet.ecommons.io.TextContentDescriber;
import org.eclipse.statet.jcommons.io.ByteOrderMark;
import org.eclipse.statet.jcommons.io.IOUtils;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.util.StringUtils;

@NonNullByDefault
public class RPkgDescriptionContentDescriber
extends TextContentDescriber {
    private static final @NonNull QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
    private static final String PACKAGE_FIELD = "Package:";
    private static final String ENCODING_FIELD = "Encoding:";

    public @NonNull QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    public int describe(Reader contents, @Nullable IContentDescription description) throws IOException {
        if (description != null && description.isRequested(IContentDescription.CHARSET)) {
            BufferedReader reader = new BufferedReader(contents);
            ParseResult result = this.parse(reader);
            if (result.isIndeterminate()) {
                return 1;
            }
            if (result.hasCharsetSpec()) {
                description.setProperty(IContentDescription.CHARSET, (Object)result.getCharsetName());
            }
        }
        return 2;
    }

    public int describe(InputStream contents, @Nullable IContentDescription description) throws IOException {
        ByteOrderMark bom = this.checkByteOrderMark(contents, description);
        contents.reset();
        BufferedReader reader = new BufferedReader(IOUtils.newStreamContentReader((InputStream)contents, (ByteOrderMark)bom, (Charset)StandardCharsets.ISO_8859_1));
        ParseResult result = this.parse(reader);
        if (result.hasCharsetSpec() && description != null) {
            description.setProperty(IContentDescription.CHARSET, (Object)result.getCharsetName());
        }
        if (result.isIndeterminate()) {
            return 1;
        }
        return 2;
    }

    private ParseResult parse(BufferedReader reader) throws IOException {
        String line;
        ParseResult result = new ParseResult();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(PACKAGE_FIELD)) {
                result.setPackage();
                continue;
            }
            if (!line.startsWith(ENCODING_FIELD)) continue;
            result.setEncoding(StringUtils.trim((String)line, (int)ENCODING_FIELD.length(), (int)line.length()));
        }
        return result;
    }

    private static class ParseResult {
        private boolean hasPackageDecl;
        private @Nullable String charset;

        public void setEncoding(String encoding) {
            if (this.charset == null) {
                this.charset = encoding;
            }
        }

        public void setPackage() {
            this.hasPackageDecl = true;
        }

        public boolean isIndeterminate() {
            return !this.hasPackageDecl;
        }

        public boolean hasCharsetSpec() {
            return this.charset != null;
        }

        public @Nullable String getCharsetName() {
            return this.charset;
        }
    }
}

