/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.util.SourceMessageUtil;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.QuickRefactoring;
import org.eclipse.statet.ltk.refactoring.core.RefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.statet.ltk.refactoring.core.TextChangeCompatibility;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.refactoring.RSourceCodeModifyUtil;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.statet.r.core.source.ast.Special;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;

@NonNullByDefault
public class IfNotNullElseToCRefactoring
extends QuickRefactoring {
    private final RRefactoringAdapter adapter = new RRefactoringAdapter();
    private final ElementSet elementSet;
    private final RSourceUnit sourceUnit;
    private final Special sourceNode;
    private final boolean withBlocks;

    public IfNotNullElseToCRefactoring(RSourceUnit su, Special sourceNode, boolean withBlocks) {
        this.sourceUnit = su;
        this.elementSet = new ElementSet(new Object[]{su});
        this.sourceNode = sourceNode;
        this.withBlocks = withBlocks;
    }

    public String getBundleId() {
        return "org.eclipse.statet.r.core";
    }

    public String getIdentifier() {
        return "org.eclipse.statet.r.refactoring.ConvertIfNotNullElseToCIfElseOperation";
    }

    public String getName() {
        return Messages.IfNotNullElseToCIfElse_label;
    }

    public boolean getWithBlocks() {
        return this.withBlocks;
    }

    public RefactoringStatus checkInitialConditions(@Nullable IProgressMonitor monitor) {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            RCoreAccess rCoreAccess = RCore.getContextAccess((IAdaptable)this.sourceUnit);
            Special sourceNode = this.sourceNode;
            if (sourceNode.getText() != "||") {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)"Cannot convert the statement.");
                return refactoringStatus;
            }
            RefactoringStatus result = new RefactoringStatus();
            this.adapter.checkInitialToModify(result, this.elementSet);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)3);
        try {
            RefactoringStatus status = new RefactoringStatus();
            this.adapter.checkFinalToModify(status, this.elementSet, (IProgressMonitor)m.newChild(2));
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_CreateChanges_label, (int)3);
        try {
            SourceUnitChange textFileChange = new SourceUnitChange((SourceUnit)this.sourceUnit);
            if (this.sourceUnit.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
                textFileChange.setSaveMode(4);
            }
            this.createChanges(textFileChange, m.newChild(2));
            textFileChange.setInsertPosition(new Position(this.sourceNode.getStartOffset(), 0));
            HashMap arguments = new HashMap();
            SourceMessageUtil messageUtil = new SourceMessageUtil(this.sourceUnit.getContent((IProgressMonitor)m));
            String description = NLS.bind((String)Messages.IfNotNullElseToCIfElse_Descriptor_description, (Object)messageUtil.getFullQuoteText((AstNode)this.sourceNode.getLeftChild()));
            IProject resource = this.elementSet.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            RefactoringChange refactoringChange = new RefactoringChange((RefactoringDescriptor)descriptor, this.getName(), new Change[]{textFileChange});
            return refactoringChange;
        }
        catch (BadLocationException e) {
            throw this.handleUnexpectedError(e);
        }
        finally {
            m.done();
        }
    }

    public SourceUnitChange createTextChange(SubMonitor m) throws CoreException {
        m.setWorkRemaining(2);
        try {
            SourceUnitChange textFileChange = new SourceUnitChange((SourceUnit)this.sourceUnit);
            this.createChanges(textFileChange, m.newChild(2));
            return textFileChange;
        }
        catch (BadLocationException e) {
            throw this.handleUnexpectedError(e);
        }
    }

    private void createChanges(SourceUnitChange change, SubMonitor m) throws BadLocationException, CoreException {
        m.setWorkRemaining(7);
        this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
        try {
            RSourceCodeModifyUtil util = new RSourceCodeModifyUtil(this.adapter, this.sourceUnit, m.newChild(1));
            Special sourceNode = this.sourceNode;
            RAstNode primaryNode = sourceNode.getLeftChild();
            RAstNode elseNode = sourceNode.getRightChild();
            RAstNode baseNode = RAsts.getSequenceChildElseRoot(sourceNode);
            int changeStart = sourceNode.getStartOffset();
            int changeEnd = sourceNode.getEndOffset();
            util.clear();
            util.append("if (!is.null(");
            util.appendUnwrapGroup(primaryNode);
            util.append("))");
            util.appendFlowControlBody(primaryNode, this.withBlocks && primaryNode.getNodeType() != NodeType.BLOCK);
            util.append(" else");
            util.appendFlowControlBody(elseNode, this.withBlocks && elseNode.getNodeType() != NodeType.BLOCK);
            if (this.withBlocks) {
                util.correctIndent(changeStart, baseNode.getStartOffset());
            }
            TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.IfNotNullElse_Changes_name, (TextEdit)util.createReplaceEdit(changeStart, changeEnd));
            m.worked(4);
            TextChangeCompatibility.addMarker((TextChange)change, (RangeMarker)new RangeMarker(changeEnd, 0));
        }
        finally {
            this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }
}

