/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import java.util.ArrayList;
import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpTopicEntry;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.BasicRPkgDescription;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkgDescription;
import org.eclipse.statet.rj.renv.core.RPkgUtils;

@NonNullByDefault
public class RPkgHelpImpl
implements RPkgHelp {
    private final String name;
    private final RPkgDescription pkgDescription;
    private final REnv rEnv;
    private ImList<RHelpPage> pages;
    private @Nullable ImList<RHelpTopicEntry> topics;

    public RPkgHelpImpl(RPkgDescription pkgDescription, REnv rEnv) {
        this.name = pkgDescription.getName();
        this.pkgDescription = pkgDescription;
        this.rEnv = rEnv;
    }

    public RPkgHelpImpl(RPkgHelp template, RLibLocation libLocation) {
        this.name = template.getName();
        this.pkgDescription = new BasicRPkgDescription(template.getPkgDescription(), libLocation);
        this.rEnv = template.getREnv();
        this.pages = template.getPages();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RNumVersion getVersion() {
        return this.pkgDescription.getVersion();
    }

    @Override
    public String getTitle() {
        return this.pkgDescription.getTitle();
    }

    @Override
    public RPkgDescription getPkgDescription() {
        return this.pkgDescription;
    }

    @Override
    public REnv getREnv() {
        return this.rEnv;
    }

    public void setPages(ImList<RHelpPage> pages) {
        this.pages = pages;
    }

    @Override
    public ImList<RHelpPage> getPages() {
        return this.pages;
    }

    @Override
    public @Nullable RHelpPage getPage(String name) {
        if (name != null) {
            for (RHelpPage page : this.pages) {
                if (!page.getName().equals(name)) continue;
                return page;
            }
        }
        return null;
    }

    public int indexOf(ImList<RHelpTopicEntry> topics, @Nullable String topic) {
        if (topic == null) {
            return -1;
        }
        int low = 0;
        int high = topics.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int diff = RHelpCoreInternals.R_NAMES_COLLATOR.compare(((RHelpTopicEntry)topics.get(mid)).getTopic(), topic);
            if (diff < 0) {
                low = mid + 1;
                continue;
            }
            if (diff > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ~low;
    }

    @Override
    public @Nullable RHelpPage getPageForTopic(String topic) {
        ImList<RHelpTopicEntry> topics = this.getTopics();
        int idx = this.indexOf(topics, topic);
        if (idx >= 0) {
            return ((RHelpTopicEntry)topics.get(idx)).getPage();
        }
        return null;
    }

    @Override
    public ImList<RHelpTopicEntry> getTopics() {
        ImList topics = this.topics;
        if (topics == null) {
            ArrayList<RHelpTopicEntry> list = new ArrayList<RHelpTopicEntry>(this.pages.size() * 3);
            for (RHelpPage page : this.pages) {
                for (String topic : page.getTopics()) {
                    list.add(new RHelpTopicEntry(topic, page));
                }
            }
            this.topics = topics = ImCollections.toList(list, null);
        }
        return topics;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        RPkgHelp other;
        return this == obj || obj instanceof RPkgHelp && this.name.equals((other = (RPkgHelp)obj).getName()) && this.rEnv.equals((Object)other.getREnv());
    }

    @Override
    public int compareTo(RPkgHelp o) {
        return RPkgUtils.NAMES_COLLATOR.compare(this.name, o.getName());
    }

    public String toString() {
        return this.name;
    }
}

