/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.server;

import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ServerApi {
    public static final String API_VERSION_1 = "api/v1";
    public static final String APPLICATION_MEDIA_TYPE = "application";
    public static final String DS_MEDIA_SUBTYPE = "x.org.eclipse.statet.rhelp-ds";
    public static final String DS_MEDIA_TYPE_STRING = "application/x.org.eclipse.statet.rhelp-ds";
    public static final String DS_SER_VERSION = "ser";
    public static final String STAMP = "stamp";
    public static final String BASIC_DATA = "basic-data";
    public static final String PKGS = "pkgs";
    public static final String PAGES = "pages";
    public static final String SEARCH = "search";
    public static final String TOPICS = "topics";
    public static final String PKG_PARAM = "pkg";
    public static final String TOPIC_PARAM = "topic";
    public static final String VERSION_PARAM = "v";
    public static final String TYPE = "type";
    public static final String QUERY_STRING_PARAM = "qs";
    public static final String MAX_FRAGMENTS_PARAM = "maxFragments";
    public static final byte END_MATCH = 0;
    public static final byte PAGE_MATCH = 1;
    public static final Pattern ETAG_PATTERN = Pattern.compile("\"(\\d+)\"");

    public static @Nullable RequestInfo extractRequestInfo(@Nullable String path) {
        int idx1;
        if (path != null && (idx1 = path.indexOf(47, 1)) >= 2) {
            String envId = path.substring(1, idx1);
            String[] segments = new String[6];
            int i = 0;
            int beginIdx = idx1 + 1;
            int stopIdx = path.length();
            if (path.charAt(stopIdx - 1) == '/') {
                --stopIdx;
            }
            while (i < segments.length && beginIdx < stopIdx) {
                int endIdx = path.indexOf(47, beginIdx);
                if (endIdx == -1 || endIdx == stopIdx) {
                    segments[i++] = path.substring(beginIdx, stopIdx);
                    return new RequestInfo(envId, i, segments);
                }
                if (endIdx <= beginIdx) break;
                segments[i++] = path.substring(beginIdx, endIdx);
                beginIdx = endIdx + 1;
            }
        }
        return null;
    }

    public static @Nullable String createETag(long stamp) {
        return stamp != 0L ? "\"" + Long.toUnsignedString(stamp) + "\"" : null;
    }

    private ServerApi() {
    }

    public static class RequestInfo {
        public final String rEnvId;
        public final int segmentCount;
        public final String[] segments;

        public RequestInfo(String rEnvId, int segmentCount, String[] segments) {
            this.rEnvId = rEnvId;
            this.segmentCount = segmentCount;
            this.segments = segments;
        }
    }
}

