/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http.ee10.jetty;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletApiResponse;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.statet.internal.rhelp.core.server.jetty.ExtMimeTypes;
import org.eclipse.statet.internal.rhelp.core.server.jetty.PathResourceHttpContentFactory;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.http.MediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.ee10.ResourceHandler;

@NonNullByDefault
public class JettyResourceHandler
extends ResourceService
implements ResourceHandler {
    private final ExtMimeTypes mediaTypes;

    public JettyResourceHandler(MediaTypeProvider defaultTypes) {
        this.mediaTypes = new ExtMimeTypes(defaultTypes);
        PathResourceHttpContentFactory contentFactory = new PathResourceHttpContentFactory(this.mediaTypes);
        this.setHttpContentFactory(contentFactory);
        this.setDirAllowed(false);
    }

    @Override
    public void setSpecialMediaTypes(MediaTypeProvider types) {
        this.mediaTypes.setSpecialMediaTypes(types);
    }

    @Override
    public void setCacheControl(String value) {
        super.setCacheControl(value);
    }

    @Override
    public void doGet(Path path, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block22: {
            HttpContent content = ((PathResourceHttpContentFactory)this.getHttpContentFactory()).getContent(path, path.toString());
            boolean releaseContent = true;
            try {
                Resource resource;
                if (content == null || (resource = content.getResource()) == null || Resources.missing((Resource)resource)) {
                    this.notFound(req, resp);
                    return;
                }
                if (resource.isDirectory()) {
                    resp.sendError(400);
                }
                ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest((ServletRequest)req);
                ServletContextResponse servletContextResponse = servletContextRequest.getServletContextResponse();
                ServletChannel servletChannel = servletContextRequest.getServletChannel();
                if (!(req instanceof ServletApiRequest) || !(resp instanceof ServletApiResponse) || servletContextResponse.isWriting() || servletContextResponse.isStreaming()) {
                    throw new UnsupportedOperationException();
                }
                Request coreRequest = servletChannel.getRequest();
                Response coreResponse = servletChannel.getResponse();
                if (coreResponse.isCommitted()) {
                    return;
                }
                long contentLength = content.getContentLengthValue();
                if (req.isAsyncSupported() && (contentLength < 0L || contentLength > (long)coreRequest.getConnectionMetaData().getHttpConfiguration().getOutputBufferSize())) {
                    AsyncContext asyncContext = req.startAsync();
                    AsyncContextCallback callback = new AsyncContextCallback(asyncContext, resp);
                    releaseContent = false;
                    this.doGet(coreRequest, coreResponse, callback, content);
                    break block22;
                }
                try {
                    Throwable asyncContext = null;
                    Object var14_17 = null;
                    try (Blocker.Callback callback = Blocker.callback();){
                        releaseContent = false;
                        this.doGet(coreRequest, coreResponse, (Callback)callback, content);
                        callback.block();
                    }
                    catch (Throwable throwable) {
                        if (asyncContext == null) {
                            asyncContext = throwable;
                        } else if (asyncContext != throwable) {
                            asyncContext.addSuppressed(throwable);
                        }
                        throw asyncContext;
                    }
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            finally {
                if (releaseContent && content != null) {
                    content.release();
                }
            }
        }
    }

    protected void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(404);
    }

    private static class AsyncContextCallback
    implements Callback {
        private final AsyncContext asyncContext;
        private final HttpServletResponse response;

        private AsyncContextCallback(AsyncContext asyncContext, HttpServletResponse response) {
            this.asyncContext = asyncContext;
            this.response = response;
        }

        public void succeeded() {
            this.asyncContext.complete();
        }

        public void failed(@Nullable Throwable x) {
            try {
                try {
                    this.response.sendError(-1);
                }
                catch (IOException e) {
                    ExceptionUtil.addSuppressedIfNotAssociated((Throwable)x, (Throwable)e);
                    this.asyncContext.complete();
                }
            }
            finally {
                this.asyncContext.complete();
            }
        }
    }
}

