/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PixelOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.layer.AbstractLayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.CompositeLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class CompositeLayerDim
extends AbstractLayerDim<CompositeLayer> {
    private final @NonNull LayerDim[] @NonNull [] childDims;

    public CompositeLayerDim(CompositeLayer layer, Orientation orientation) {
        super(layer, orientation);
        this.childDims = orientation == Orientation.HORIZONTAL ? new LayerDim[layer.layoutXCount][layer.layoutYCount] : new LayerDim[layer.layoutYCount][layer.layoutXCount];
    }

    @Override
    public CompositeLayer getLayer() {
        return (CompositeLayer)this.layer;
    }

    void setChild(int layout, int layout2, Layer childLayer) {
        this.childDims[layout][layout2] = childLayer.getDim(this.orientation);
    }

    protected final int getLayoutByPosition(long position) {
        if (position >= 0L) {
            int layout = 0;
            int offset = 0;
            while (layout < this.childDims.length) {
                if (position < (long)(offset = (int)((long)offset + this.childDims[layout][0].getPositionCount()))) {
                    return layout;
                }
                ++layout;
            }
        }
        return -1;
    }

    protected final int getLayoutByPixel(long pixel) {
        if (pixel >= 0L) {
            int layout = 0;
            int offset = 0;
            while (layout < this.childDims.length) {
                if (pixel < (long)(offset = (int)((long)offset + this.childDims[layout][0].getSize()))) {
                    return layout;
                }
                ++layout;
            }
        }
        return -1;
    }

    protected final int getLayoutByDim(LayerDim childDim) {
        int layout = 0;
        while (layout < this.childDims.length) {
            LayerDim[] layoutDims = this.childDims[layout];
            int layout2 = 0;
            while (layout2 < layoutDims.length) {
                if (layoutDims[layout2] == childDim) {
                    return layout;
                }
                ++layout2;
            }
            ++layout;
        }
        return -1;
    }

    protected final long getLayoutPosition(int layout) {
        long offset = 0L;
        int i = 0;
        while (i < layout) {
            offset += this.childDims[i][0].getPositionCount();
            ++i;
        }
        return offset;
    }

    protected final long getLayoutStart(int layout) {
        long start = 0L;
        int i = 0;
        while (i < layout) {
            start += this.childDims[i][0].getSize();
            ++i;
        }
        return start;
    }

    @Override
    public long getPositionId(long refPosition, long position) {
        int layout = this.getLayoutByPosition(refPosition);
        if (layout < 0) {
            throw PositionOutOfBoundsException.refPosition(refPosition, this.getOrientation());
        }
        long layoutPosition = this.getLayoutPosition(layout);
        return this.childDims[layout][0].getPositionId(refPosition - layoutPosition, position - layoutPosition);
    }

    @Override
    public long getPositionById(long id) {
        int i = 0;
        while (i < this.childDims.length) {
            long underlyingPosition = this.childDims[i][0].getPositionById(id);
            if (underlyingPosition >= 0L && underlyingPosition < this.childDims[i][0].getPositionCount()) {
                long layoutPosition = this.getLayoutPosition(i);
                return layoutPosition + underlyingPosition;
            }
            ++i;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long getPositionCount() {
        long count = 0L;
        int layout = 0;
        while (layout < this.childDims.length) {
            count += this.childDims[layout][0].getPositionCount();
            ++layout;
        }
        return count;
    }

    @Override
    public long localToUnderlyingPosition(long refPosition, long position) {
        int layout = this.getLayoutByPosition(refPosition);
        if (layout < 0) {
            throw PositionOutOfBoundsException.refPosition(refPosition, this.getOrientation());
        }
        return position - this.getLayoutPosition(layout);
    }

    public long underlyingToLocalPosition(long refPosition, long underlyingPosition) {
        int layout = this.getLayoutByPosition(refPosition);
        if (layout < 0) {
            throw PositionOutOfBoundsException.refPosition(refPosition, this.getOrientation());
        }
        long layoutPosition = this.getLayoutPosition(layout);
        return layoutPosition + underlyingPosition;
    }

    @Override
    public long underlyingToLocalPosition(LayerDim sourceUnderlyingDim, long underlyingPosition) {
        int layout = this.getLayoutByDim(sourceUnderlyingDim);
        if (layout < 0) {
            throw new IllegalArgumentException("underlyingLayer");
        }
        long layoutPosition = this.getLayoutPosition(layout);
        return layoutPosition + underlyingPosition;
    }

    @Override
    public List<LRange> underlyingToLocalPositions(LayerDim sourceUnderlyingDim, Collection<LRange> underlyingPositionRanges) {
        int layout = this.getLayoutByDim(sourceUnderlyingDim);
        if (layout < 0) {
            throw new IllegalArgumentException("underlyingLayer");
        }
        ArrayList<LRange> localPositionRanges = new ArrayList<LRange>();
        long layoutPosition = this.getLayoutPosition(layout);
        for (LRange underlyingPositionRange : underlyingPositionRanges) {
            localPositionRanges.add(new LRange(layoutPosition + underlyingPositionRange.start, layoutPosition + underlyingPositionRange.end));
        }
        return localPositionRanges;
    }

    @Override
    public @Nullable ImList<LayerDim> getUnderlyingDimsByPosition(long position) {
        int layout = this.getLayoutByPosition(position);
        if (layout < 0) {
            return null;
        }
        return ImCollections.newList((Object[])this.childDims[layout]);
    }

    @Override
    public long getSize() {
        long size = 0L;
        int layout = 0;
        while (layout < this.childDims.length) {
            size += this.childDims[layout][0].getSize();
            ++layout;
        }
        return size;
    }

    @Override
    public long getPreferredSize() {
        long size = 0L;
        int layout = 0;
        while (layout < this.childDims.length) {
            size += this.childDims[layout][0].getPreferredSize();
            ++layout;
        }
        return size;
    }

    @Override
    public long getPositionByPixel(long pixel) {
        int layout = this.getLayoutByPixel(pixel);
        if (layout < 0) {
            throw new PixelOutOfBoundsException(pixel, this.getOrientation());
        }
        long childPosition = this.childDims[layout][0].getPositionByPixel(pixel - this.getLayoutStart(layout));
        return this.getLayoutPosition(layout) + childPosition;
    }

    @Override
    public long getPositionStart(long refPosition, long position) {
        int layout = this.getLayoutByPosition(refPosition);
        if (layout < 0) {
            throw PositionOutOfBoundsException.refPosition(refPosition, this.getOrientation());
        }
        long layoutPosition = this.getLayoutPosition(layout);
        return this.getLayoutStart(layout) + this.childDims[layout][0].getPositionStart(refPosition - layoutPosition, position - layoutPosition);
    }

    @Override
    public long getPositionStart(long position) {
        int layout = this.getLayoutByPosition(position);
        if (layout < 0) {
            throw new PositionOutOfBoundsException(position, this.getOrientation());
        }
        long layoutPosition = this.getLayoutPosition(layout);
        return this.getLayoutStart(layout) + this.childDims[layout][0].getPositionStart(position - layoutPosition);
    }

    @Override
    public int getPositionSize(long refPosition, long position) {
        int layout = this.getLayoutByPosition(refPosition);
        if (layout < 0) {
            throw PositionOutOfBoundsException.refPosition(refPosition, this.getOrientation());
        }
        long layoutPosition = this.getLayoutPosition(layout);
        return this.childDims[layout][0].getPositionSize(refPosition - layoutPosition, position - layoutPosition);
    }

    @Override
    public int getPositionSize(long position) {
        int layout = this.getLayoutByPosition(position);
        if (layout < 0) {
            throw new PositionOutOfBoundsException(position, this.getOrientation());
        }
        long layoutPosition = this.getLayoutPosition(layout);
        return this.childDims[layout][0].getPositionSize(position - layoutPosition);
    }

    @Override
    public boolean isPositionResizable(long position) {
        int layout = this.getLayoutByPosition(position);
        if (layout < 0) {
            return false;
        }
        long layoutPosition = this.getLayoutPosition(layout);
        return this.childDims[layout][0].isPositionResizable(position - layoutPosition);
    }

    public static class IgnoreRef
    extends CompositeLayerDim {
        public IgnoreRef(CompositeLayer layer, Orientation orientation) {
            super(layer, orientation);
        }

        @Override
        public long getPositionId(long refPosition, long position) {
            return super.getPositionId(position, position);
        }

        @Override
        public long localToUnderlyingPosition(long refPosition, long position) {
            return super.localToUnderlyingPosition(position, position);
        }

        @Override
        public long getPositionStart(long refPosition, long position) {
            return super.getPositionStart(position);
        }

        @Override
        public int getPositionSize(long refPosition, long position) {
            return super.getPositionSize(position);
        }
    }
}

