/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IEditableRule;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.data.convert.IDisplayConverter;
import org.eclipse.statet.ecommons.waltable.edit.ActiveCellEditorRegistry;
import org.eclipse.statet.ecommons.waltable.edit.EditConfigAttributes;
import org.eclipse.statet.ecommons.waltable.edit.editor.ICellEditor;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;

public class EditUtils {
    public static LayerCell getLastSelectedCell(SelectionLayer selectionLayer) {
        PositionCoordinate selectionAnchor = selectionLayer.getSelectionAnchor();
        return selectionLayer.getCellByPosition(selectionAnchor.columnPosition, selectionAnchor.rowPosition);
    }

    public static ICellEditor getLastSelectedCellEditor(SelectionLayer selectionLayer, ConfigRegistry configRegistry) {
        LayerCell lastSelectedCell = EditUtils.getLastSelectedCell(selectionLayer);
        if (lastSelectedCell != null) {
            List<String> lastSelectedCellLabelsArray = lastSelectedCell.getLabels().getLabels();
            return configRegistry.getAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.EDIT, lastSelectedCellLabelsArray);
        }
        return null;
    }

    public static boolean allCellsEditable(SelectionLayer selectionLayer, ConfigRegistry configRegistry) {
        Collection<LayerCell> selectedCells = selectionLayer.getSelectedCells();
        for (LayerCell layerCell : selectedCells) {
            LabelStack labelStack = layerCell.getLabels();
            IEditableRule editableRule = configRegistry.getAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, DisplayMode.EDIT, labelStack.getLabels());
            if (editableRule.isEditable(layerCell, configRegistry)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCellEditable(SelectionLayer selectionLayer, ConfigRegistry configRegistry, PositionCoordinate cellCoords) {
        LayerCell layerCell = selectionLayer.getCellByPosition(cellCoords.columnPosition, cellCoords.rowPosition);
        LabelStack labelStack = layerCell.getLabels();
        IEditableRule editableRule = configRegistry.getAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, DisplayMode.EDIT, labelStack.getLabels());
        if (editableRule == null) {
            return false;
        }
        return editableRule.isEditable(layerCell, configRegistry);
    }

    public static boolean isEditorSame(SelectionLayer selectionLayer, ConfigRegistry configRegistry) {
        List<PositionCoordinate> selectedCells = selectionLayer.getSelectedCellPositions();
        ICellEditor lastSelectedCellEditor = null;
        for (PositionCoordinate selectedCell : selectedCells) {
            LayerCell cell = selectionLayer.getCellByPosition(selectedCell.columnPosition, selectedCell.rowPosition);
            ICellEditor cellEditor = configRegistry.getAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.EDIT, cell.getLabels().getLabels());
            if (lastSelectedCellEditor == null) {
                lastSelectedCellEditor = cellEditor;
            }
            if (cellEditor == lastSelectedCellEditor) continue;
            return false;
        }
        return true;
    }

    public static boolean isConverterSame(SelectionLayer selectionLayer, ConfigRegistry configRegistry) {
        List<PositionCoordinate> selectedCells = selectionLayer.getSelectedCellPositions();
        HashSet converterSet = new HashSet();
        for (PositionCoordinate selectedCell : selectedCells) {
            LayerCell cell = selectionLayer.getCellByPosition(selectedCell.columnPosition, selectedCell.rowPosition);
            IDisplayConverter dataTypeConverter = configRegistry.getAttribute(CellConfigAttributes.DISPLAY_CONVERTER, DisplayMode.EDIT, cell.getLabels().getLabels());
            if (dataTypeConverter != null) {
                converterSet.add(dataTypeConverter.getClass());
            }
            if (converterSet.size() <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValueSame(SelectionLayer selectionLayer) {
        Object lastSelectedValue = null;
        Collection<LayerCell> selectedCells = selectionLayer.getSelectedCells();
        for (LayerCell layerCell : selectedCells) {
            Object cellValue = layerCell.getDataValue(0, null);
            if (lastSelectedValue == null) {
                lastSelectedValue = cellValue;
            }
            if ((cellValue == null || cellValue.equals(lastSelectedValue)) && (cellValue != null || lastSelectedValue == null)) continue;
            return false;
        }
        return true;
    }

    public static boolean commitAndCloseActiveEditor() {
        ICellEditor activeCellEditor = ActiveCellEditorRegistry.getActiveCellEditor();
        if (activeCellEditor != null) {
            return activeCellEditor.commit(null, true);
        }
        return true;
    }
}

