/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.resize;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.ui.matcher.MouseEventMatcher;
import org.eclipse.statet.ecommons.waltable.ui.util.CellEdgeDetectUtil;
import org.eclipse.swt.events.MouseEvent;

public class ColumnResizeEventMatcher
extends MouseEventMatcher {
    public ColumnResizeEventMatcher(int button, boolean rowColumn) {
        super(0, "COLUMN_HEADER", rowColumn ? "CORNER" : null, button);
    }

    public ColumnResizeEventMatcher(int button) {
        this(0, "COLUMN_HEADER", button);
    }

    public ColumnResizeEventMatcher(int stateMask, String eventRegion, int button) {
        super(stateMask, eventRegion, button);
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        return super.matches(natTable, event, regionLabels) && this.isResizable(natTable, event);
    }

    private boolean isResizable(Layer natLayer, MouseEvent event) {
        long columnPosition = CellEdgeDetectUtil.getPositionToResize(natLayer, new LPoint(event.x, event.y), Orientation.HORIZONTAL);
        return columnPosition >= 0L && natLayer.getDim(Orientation.HORIZONTAL).isPositionResizable(columnPosition);
    }
}

