/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.resize;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.ui.matcher.MouseEventMatcher;
import org.eclipse.statet.ecommons.waltable.ui.util.CellEdgeDetectUtil;
import org.eclipse.swt.events.MouseEvent;

public class RowResizeEventMatcher
extends MouseEventMatcher {
    public RowResizeEventMatcher(int button) {
        this(0, "ROW_HEADER", button);
    }

    public RowResizeEventMatcher(int stateMask, String eventRegion, int button) {
        super(stateMask, eventRegion, button);
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        return super.matches(natTable, event, regionLabels) && this.isResizable(natTable, event);
    }

    private boolean isResizable(Layer natLayer, MouseEvent event) {
        long rowPosition = CellEdgeDetectUtil.getPositionToResize(natLayer, new LPoint(event.x, event.y), Orientation.VERTICAL);
        return rowPosition >= 0L && natLayer.getDim(Orientation.VERTICAL).isPositionResizable(rowPosition);
    }
}

