/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.util.data;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.util.data.PropertyColumnAccessor;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ReflectivePropertyColumnAccessor<R>
implements PropertyColumnAccessor<R> {
    private final List<String> propertyNames;
    private final Map<Class<?>, Map<String, PropertyDescriptor>> propertyDescriptorMap = new HashMap();

    public ReflectivePropertyColumnAccessor(String ... propertyNames) {
        this.propertyNames = ImCollections.newList((Object[])propertyNames);
    }

    @Override
    public long getColumnCount() {
        return this.propertyNames.size();
    }

    @Override
    public @Nullable Object getDataValue(R rowObj, long columnIndex) {
        try {
            PropertyDescriptor propertyDesc = this.getPropertyDescriptor(rowObj, this.getColumnProperty(columnIndex));
            Method readMethod = propertyDesc.getReadMethod();
            return readMethod.invoke(rowObj, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDataValue(@NonNull R rowObj, long columnIndex, @Nullable Object newValue) {
        try {
            PropertyDescriptor propertyDesc = this.getPropertyDescriptor(rowObj, this.getColumnProperty(columnIndex));
            Method writeMethod = propertyDesc.getWriteMethod();
            if (writeMethod == null) {
                throw new RuntimeException("Setter method not found in backing bean for value at column index: " + columnIndex);
            }
            writeMethod.invoke(rowObj, newValue);
        }
        catch (IllegalArgumentException ex) {
            WaLTablePlugin.log((IStatus)new Status(2, "org.eclipse.statet.ecommons.waltable.core", "Data type being set does not match the data type of the setter method in the backing bean", (Throwable)ex));
        }
        catch (Exception e) {
            WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Error while setting data value", (Throwable)e));
            throw new RuntimeException("Error while setting data value");
        }
    }

    @Override
    public String getColumnProperty(long columnIndex) {
        if (columnIndex < 0L || columnIndex >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        return this.propertyNames.get((int)columnIndex);
    }

    @Override
    public long getColumnIndex(String propertyName) {
        return this.propertyNames.indexOf(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyDescriptor getPropertyDescriptor(@NonNull R rowObj, String propertyName) throws IntrospectionException {
        Map<Class<?>, Map<String, PropertyDescriptor>> map = this.propertyDescriptorMap;
        synchronized (map) {
            Map<String, PropertyDescriptor> map2 = this.propertyDescriptorMap.get(rowObj.getClass());
            if (map2 == null) {
                PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(rowObj.getClass()).getPropertyDescriptors();
                map2 = new HashMap<String, PropertyDescriptor>();
                PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
                int n = propertyDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                    map2.put(propertyDescriptor.getName(), propertyDescriptor);
                    ++n2;
                }
                this.propertyDescriptorMap.put(rowObj.getClass(), map2);
            }
            return map2.get(propertyName);
        }
    }
}

