/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.jface;

import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.databinding.core.util.DirtyTracker;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class DataBindingSupport {
    private static final int STARTED = 1;
    private static final int DISPOSING = 2;
    private static final int DISPOSED = 3;
    private Realm realm = Realm.getDefault();
    private DataBindingContext dbc = this.createContext(this.realm);
    private @Nullable DirtyTracker tracker;
    private int state;

    public DataBindingSupport(Control rootControl) {
        rootControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DataBindingSupport.this.dispose();
            }
        });
        this.state = 1;
    }

    protected DataBindingContext createContext(Realm realm) {
        return new DataBindingContext(realm);
    }

    public DataBindingContext getContext() {
        return this.dbc;
    }

    public Realm getRealm() {
        return this.realm;
    }

    private void dispose() {
        DataBindingContext dbc = this.dbc;
        if (dbc != null) {
            this.state = 2;
            try {
                dbc.dispose();
            }
            catch (Throwable e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "An error occurend when dispose databinding", e));
            }
            this.state = 3;
            this.dbc = null;
            this.realm = null;
        }
    }

    public void installStatusListener(final StatusChangeListener listener) {
        if (this.state > 1) {
            throw new IllegalStateException();
        }
        final AggregateValidationStatus validationStatus = new AggregateValidationStatus(this.dbc, 2);
        validationStatus.addValueChangeListener((IValueChangeListener)new IValueChangeListener<IStatus>(){

            public void handleValueChange(ValueChangeEvent<? extends IStatus> event) {
                if (DataBindingSupport.this.state == 1) {
                    IStatus status = (IStatus)event.diff.getNewValue();
                    listener.statusChanged(status);
                }
            }
        });
        listener.statusChanged((IStatus)validationStatus.getValue());
        this.tracker = new DirtyTracker(this.dbc){

            public void handleChange(@Nullable ObservableEvent event) {
                if (!this.isDirty()) {
                    if (DataBindingSupport.this.state == 1) {
                        listener.statusChanged((IStatus)validationStatus.getValue());
                    }
                    super.handleChange(event);
                }
            }
        };
    }

    public void updateStatus() {
        DirtyTracker tracker = this.tracker;
        if (tracker != null) {
            tracker.resetDirty();
            tracker.handleChange(null);
        }
    }
}

