/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class DataAdapter<TItem> {
    private Set<TItem> checkedSet;
    protected final IObservableValue defaultValue;
    private boolean isDirty;

    public DataAdapter(IObservableValue<? extends @Nullable Object> defaultValue) {
        this.defaultValue = defaultValue;
    }

    public @Nullable Object getAddParent(Object element) {
        return null;
    }

    public @Nullable Object getParent(Object element) {
        return null;
    }

    public @NonNull Object @Nullable [] getChildren(Object element) {
        return null;
    }

    public boolean isAddAllowed(Object element) {
        return true;
    }

    public boolean isContentItem(@Nullable Object element) {
        return true;
    }

    public boolean isModifyAllowed(Object element) {
        return this.isContentItem(element);
    }

    public boolean isMoveAllowed(Object element, int direction) {
        return this.isModifyAllowed(element);
    }

    public boolean isDeleteAllowed(Object element) {
        return this.isModifyAllowed(element);
    }

    public TItem getModelItem(Object element) {
        return (TItem)element;
    }

    public Object getViewerElement(TItem item, @Nullable Object parent) {
        return item;
    }

    public void setCheckedModel(Set<TItem> set) {
        this.checkedSet = set;
    }

    protected @Nullable Object getContainerFor(Object element) {
        return null;
    }

    protected @Nullable IObservableValue getDefaultFor(TItem item) {
        return this.defaultValue;
    }

    public void setDefault(TItem item) {
        IObservableValue observable = this.getDefaultFor(item);
        if (observable == null) {
            return;
        }
        this.isDirty = true;
        if (item != null) {
            observable.setValue(this.getDefaultValue(item));
        }
    }

    public Object change(@Nullable TItem oldItem, TItem newItem, Object parent, @Nullable Object container) {
        if (container instanceof Collection) {
            Collection list = (Collection)container;
            this.setDirty(true);
            this.changeDefault(oldItem, newItem);
            if (oldItem == null) {
                list.add(newItem);
            } else if (oldItem != newItem) {
                if (list instanceof List) {
                    int idx = ((List)list).indexOf(oldItem);
                    ((List)list).set(idx, newItem);
                } else {
                    list.remove(oldItem);
                    list.add(newItem);
                }
            }
            Object editElement = this.getViewerElement(newItem, parent);
            this.changeChecked(oldItem, newItem);
            return editElement;
        }
        throw new UnsupportedOperationException();
    }

    protected Object getDefaultValue(@Nullable TItem item) {
        return item;
    }

    protected void changeDefault(@Nullable TItem oldItem, @Nullable TItem newItem) {
        Object newValue;
        if (oldItem == null) {
            return;
        }
        IObservableValue observable = this.getDefaultFor(oldItem);
        if (observable == null) {
            return;
        }
        Object oldValue = this.getDefaultValue(oldItem);
        if (oldValue != (newValue = this.getDefaultValue(newItem)) && oldValue.equals(observable.getValue())) {
            observable.setValue(newValue);
        }
    }

    protected void changeChecked(TItem oldItem, TItem newItem) {
        if (this.checkedSet != null) {
            if (oldItem == null) {
                this.checkedSet.add(newItem);
            } else if (this.checkedSet.remove(oldItem)) {
                this.checkedSet.add(newItem);
            }
        }
    }

    public void delete(List<? extends @NonNull Object> elements) {
        this.setDirty(true);
        this.deleteDefault(elements);
        for (Object object : elements) {
            this.delete(this.getModelItem(object), this.getContainerFor(object));
        }
        this.deleteChecked(elements);
    }

    protected void delete(TItem item, @Nullable Object container) {
        if (!(container instanceof Collection)) {
            throw new UnsupportedOperationException();
        }
        ((Collection)container).remove(item);
    }

    protected void deleteDefault(List<? extends @NonNull Object> elements) {
        if (elements.isEmpty()) {
            return;
        }
        for (Object object : elements) {
            Object itemValue;
            IObservableValue observable;
            TItem item = this.getModelItem(object);
            if (item == null || (observable = this.getDefaultFor(item)) == null || (itemValue = this.getDefaultValue(item)) == null || !itemValue.equals(observable.getValue())) continue;
            observable.setValue(null);
            return;
        }
    }

    protected void deleteChecked(List<? extends @NonNull Object> elements) {
        if (this.checkedSet != null) {
            this.checkedSet.removeAll(elements);
        }
    }

    public void move(Object item, int direction) {
        throw new UnsupportedOperationException();
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public static class ListAdapter<TItem>
    extends DataAdapter<TItem> {
        final IObservableCollection<TItem> list;

        public ListAdapter(IObservableCollection<TItem> list, IObservableValue<@Nullable TItem> defaultValue) {
            super(defaultValue);
            this.list = (IObservableCollection)ObjectUtils.nonNullAssert(list);
        }

        @Override
        public Object getAddParent(Object element) {
            return this.list;
        }

        @Override
        public Object getParent(Object element) {
            return this.list;
        }

        @Override
        protected Collection<? super TItem> getContainerFor(Object element) {
            return this.list;
        }

        @Override
        public boolean isMoveAllowed(Object element, int direction) {
            if (!super.isMoveAllowed(element, direction)) {
                return false;
            }
            if (this.list instanceof List) {
                int oldIdx = ((List)this.list).indexOf(element);
                int newIdx = oldIdx + direction;
                return oldIdx >= 0 && newIdx >= 0 & newIdx < this.list.size();
            }
            return false;
        }

        @Override
        public void delete(List<? extends @NonNull Object> elements) {
            this.setDirty(true);
            this.deleteDefault(elements);
            this.list.removeAll(elements);
            this.deleteChecked(elements);
        }

        @Override
        public void move(Object item, int direction) {
            int oldIdx = ((IObservableList)this.list).indexOf(item);
            int newIdx = oldIdx + direction;
            if (oldIdx < 0 || newIdx < 0 || newIdx >= this.list.size()) {
                return;
            }
            this.moveByIdx(oldIdx, newIdx);
        }

        protected void moveByIdx(int oldIdx, int newIdx) {
            ((IObservableList)this.list).move(oldIdx, newIdx);
        }

        @Override
        protected void changeDefault(@Nullable TItem oldItem, TItem newItem) {
            if (oldItem == null) {
                if (this.defaultValue != null && this.list.isEmpty()) {
                    this.defaultValue.setValue(newItem);
                }
                return;
            }
            super.changeDefault(oldItem, newItem);
        }
    }

    public static class TreeAdapter<TItem>
    extends DataAdapter<TItem> {
        private final ITreeContentProvider contentProvider;

        public TreeAdapter(ITreeContentProvider contentProvider, IObservableValue<? extends @Nullable Object> defaultValue) {
            super(defaultValue);
            this.contentProvider = (ITreeContentProvider)ObjectUtils.nonNullAssert((Object)contentProvider);
        }

        @Override
        public @Nullable Object getAddParent(Object element) {
            if (this.isContentItem(element)) {
                return this.getParent(element);
            }
            return element;
        }

        @Override
        public @Nullable Object getParent(Object element) {
            return this.contentProvider.getParent(element);
        }

        @Override
        public @NonNull Object[] getChildren(Object element) {
            return this.contentProvider.getChildren(element);
        }
    }
}

