/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IObjValueWidget;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

@NonNullByDefault
public class DoubleText
implements IObjValueWidget<Double> {
    private final Text text;
    private @Nullable Double value;
    private final CopyOnWriteIdentityListSet<IObjValueListener<@Nullable Double>> valueListeners = new CopyOnWriteIdentityListSet();
    private double increment;
    private double min;
    private double max = Double.NaN;
    private @Nullable DecimalFormat format;

    public static DecimalFormat createFormat(int maxDigits) {
        DecimalFormat format = new DecimalFormat("0.0");
        format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance((Locale)Locale.ENGLISH));
        format.setMaximumFractionDigits(maxDigits);
        format.setRoundingMode(RoundingMode.HALF_DOWN.ordinal());
        return format;
    }

    public DoubleText(Composite parent, int flags) {
        this.text = new Text(parent, 0x4004 | flags);
        SWTListener swtListener = new SWTListener();
        this.text.addListener(24, (Listener)swtListener);
        this.text.addListener(1, (Listener)swtListener);
    }

    public Text getControl() {
        return this.text;
    }

    @Override
    public Class<@Nullable Double> getValueType() {
        return ObjectUtils.Nullable_Double_TYPE;
    }

    public void setIncrement(double v) {
        this.increment = v;
    }

    public void setMinMax(double min, double max) {
        if (Double.isNaN(min) || Double.isNaN(max)) {
            this.min = 0.0;
            this.max = Double.NaN;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    public void setFormat(@Nullable DecimalFormat format) {
        this.format = format;
    }

    @Override
    public void addValueListener(IObjValueListener<@Nullable Double> listener) {
        this.valueListeners.add((Object)((IObjValueListener)ObjectUtils.nonNullAssert(listener)));
    }

    @Override
    public void removeValueListener(IObjValueListener<@Nullable Double> listener) {
        this.valueListeners.remove(listener);
    }

    @Override
    public @Nullable Double getValue(int idx) {
        return this.value;
    }

    @Override
    public void setValue(int idx, @Nullable Double value) {
        this.text.setText(this.formatValue(value));
    }

    private void incrementValue(double increment) {
        double newValue;
        Double oldValue = this.value;
        double d = newValue = oldValue != null ? oldValue + increment : this.min;
        if (!Double.isNaN(this.max)) {
            if (newValue < this.min) {
                newValue = this.min;
            } else if (newValue > this.max) {
                newValue = this.max;
            }
        }
        this.text.setText(this.formatValue(newValue));
    }

    protected @Nullable Double parseValue(String text) {
        try {
            return Double.valueOf(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected String formatValue(@Nullable Double value) {
        if (value == null) {
            return "";
        }
        DecimalFormat format = this.format;
        return format != null ? format.format(value.doubleValue()) : value.toString();
    }

    private void updateValue(int time) {
        Double oldValue = this.value;
        Double newValue = this.parseValue(this.text.getText());
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        this.value = newValue;
        ObjValueEvent<Double> event = new ObjValueEvent<Double>(this, time, 0, oldValue, newValue, 0);
        for (IObjValueListener listener : this.valueListeners) {
            event.newValue = newValue;
            listener.valueChanged(event);
        }
    }

    private class SWTListener
    implements Listener {
        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 24: {
                    DoubleText.this.updateValue(event.time);
                    return;
                }
                case 1: {
                    switch (event.keyCode) {
                        case 0x1000001: {
                            DoubleText.this.incrementValue(DoubleText.this.increment);
                            event.doit = false;
                            return;
                        }
                        case 0x1000002: {
                            DoubleText.this.incrementValue(-DoubleText.this.increment);
                            event.doit = false;
                            return;
                        }
                        case 0x1000005: {
                            DoubleText.this.incrementValue(DoubleText.this.increment * 10.0);
                            event.doit = false;
                            return;
                        }
                        case 0x1000006: {
                            DoubleText.this.incrementValue(-DoubleText.this.increment * 10.0);
                            event.doit = false;
                            return;
                        }
                    }
                }
            }
        }
    }
}

