/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public abstract class BrowserHandler
extends AbstractHandler {
    private IBrowserProvider browserProvider;

    public BrowserHandler() {
    }

    public BrowserHandler(final Browser browser) {
        this.browserProvider = new IBrowserProvider(){

            @Override
            public Browser getBrowser() {
                return browser;
            }

            @Override
            public void showMessage(IStatus status) {
            }
        };
    }

    public BrowserHandler(IBrowserProvider browser) {
        this.browserProvider = browser;
    }

    public @Nullable Browser getBrowser() {
        return this.browserProvider.getBrowser();
    }

    protected void showMessage(int severity, String message) {
        this.browserProvider.showMessage((IStatus)new StatusInfo(severity, message));
    }

    public static class CancelHandler
    extends BrowserHandler {
        public CancelHandler(Browser browser) {
            super(browser);
        }

        public CancelHandler(IBrowserProvider browser) {
            super(browser);
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            Browser browser = this.getBrowser();
            this.setBaseEnabled(UIAccess.isOkToUse((Control)browser));
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            Browser browser = this.getBrowser();
            if (UIAccess.isOkToUse((Control)browser)) {
                browser.stop();
            }
            return null;
        }
    }

    public static interface IBrowserProvider {
        public @Nullable Browser getBrowser();

        public void showMessage(IStatus var1);
    }

    public static class NavigateBackHandler
    extends BrowserHandler {
        public NavigateBackHandler(Browser browser) {
            super(browser);
        }

        public NavigateBackHandler(IBrowserProvider browser) {
            super(browser);
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            Browser browser = this.getBrowser();
            this.setBaseEnabled(UIAccess.isOkToUse((Control)browser) && browser.isBackEnabled());
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            Browser browser = this.getBrowser();
            if (UIAccess.isOkToUse((Control)browser)) {
                browser.back();
            }
            return null;
        }
    }

    public static class NavigateForwardHandler
    extends BrowserHandler {
        public NavigateForwardHandler(Browser browser) {
            super(browser);
        }

        public NavigateForwardHandler(IBrowserProvider browser) {
            super(browser);
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            Browser browser = this.getBrowser();
            this.setBaseEnabled(UIAccess.isOkToUse((Control)browser) && browser.isForwardEnabled());
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            Browser browser = this.getBrowser();
            if (UIAccess.isOkToUse((Control)browser)) {
                browser.forward();
            }
            return null;
        }
    }

    public static class OpenExternalHandler
    extends BrowserHandler {
        public OpenExternalHandler(Browser browser) {
            super(browser);
        }

        public OpenExternalHandler(IBrowserProvider browser) {
            super(browser);
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            Browser browser = this.getBrowser();
            this.setBaseEnabled(browser != null && browser.getUrl().length() > 0);
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            Browser browser = this.getBrowser();
            if (browser != null) {
                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    this.open(browser.getUrl(), browserSupport.getExternalBrowser());
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", -1, "An error occurred when opening the page in an external browser.", (Throwable)e));
                    this.showMessage(4, "Open external browser failed");
                }
            }
            return null;
        }

        protected void open(String url, IWebBrowser webBrowser) throws Exception {
            webBrowser.openURL(new URL(url));
        }
    }
}

