/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.statet.jcommons.collections.ImCollection;

public class TypedViewerFilter
extends ViewerFilter {
    private final ImCollection<Class<?>> acceptedTypes;
    private final ImCollection<Object> rejectedElements;

    public TypedViewerFilter(ImCollection<Class<?>> acceptedTypes) {
        this(acceptedTypes, null);
    }

    public TypedViewerFilter(ImCollection<Class<?>> acceptedTypes, ImCollection<Object> rejectedElements) {
        if (acceptedTypes == null) {
            throw new NullPointerException("acceptedTypes");
        }
        this.acceptedTypes = acceptedTypes;
        this.rejectedElements = rejectedElements;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.rejectedElements != null && this.rejectedElements.contains(element)) {
            return false;
        }
        for (Class acceptedType : this.acceptedTypes) {
            if (!acceptedType.isInstance(element)) continue;
            return true;
        }
        return false;
    }
}

