/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.launching;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileValidator;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariableResolver;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariables;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.workspace.ResourceVariableUtil;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.internal.r.apps.core.shiny.RShinyResourceTester;
import org.eclipse.statet.internal.r.apps.ui.Messages;
import org.eclipse.statet.internal.r.apps.ui.launching.AppControlConfigs;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.IWorkbenchPage;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.TYPE_BOUND, NullDefaultLocation.TYPE_ARGUMENT})
public class AppControlLaunchConfig {
    private ResourceVariableUtil selectedResourceUtil;
    private IResource appFolder;
    private ResourceVariableUtil appFolderrUtil;
    private Map<String, IStringVariable> globalVariables;
    private String appHost;
    private int appPort;
    private String startCode;
    private String stopCode;
    private String viewerId;
    private String variablesCode;
    private int variablesViewAction;
    private int stopBlocking;

    protected static CoreException createMissingConfigAttr(String attrName) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.apps", NLS.bind((String)"Invalid configuration: configuration attribute ''{0}'' is missing.", (Object)attrName)));
    }

    protected static CoreException createValidationFailed(FileValidator validator) {
        IStatus status = validator.getStatus();
        return new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.apps", status.getMessage()));
    }

    public Map<String, IStringVariable> getVariables() {
        if (this.globalVariables == null) {
            this.globalVariables = new HashMap<String, IStringVariable>();
        }
        return this.globalVariables;
    }

    public void initSource(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
        IResource appFolder;
        FileValidator validator = new FileValidator(true);
        validator.setResourceLabel("app resource");
        validator.setRequireWorkspace(true, true);
        IPath explicitePath = null;
        String path = configuration.getAttribute("org.eclipse.statet.r.apps/AppSource.path", null);
        if (path != null) {
            explicitePath = Path.fromPortableString((String)path);
        }
        if (explicitePath != null) {
            validator.setExplicit((Object)explicitePath);
        } else {
            UIAccess.getDisplay().syncExec(() -> {
                ResourceVariableUtil util = new ResourceVariableUtil();
                util.getResource();
                this.selectedResourceUtil = util;
            });
            if (this.selectedResourceUtil.getResource() == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.apps", "No resource selected in the active Workbench window."));
            }
            validator.setExplicit((Object)this.selectedResourceUtil.getResource());
        }
        if (validator.getStatus().getSeverity() == 4) {
            throw AppControlLaunchConfig.createValidationFailed(validator);
        }
        this.setSelectedResource(validator.getWorkspaceResource());
        if (explicitePath != null) {
            appFolder = this.selectedResourceUtil.getResource();
        } else {
            appFolder = RShinyResourceTester.getAppContainer(this.selectedResourceUtil.getResource());
            if (appFolder == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.apps", NLS.bind((String)"Could not find app folder for ''{0}''.", (Object)this.selectedResourceUtil.getResource())));
            }
        }
        this.initAppFolder(appFolder);
    }

    protected void setSelectedResource(IResource resource) {
        if (this.selectedResourceUtil == null) {
            UIAccess.getDisplay().syncExec(() -> {
                ResourceVariableUtil util;
                this.selectedResourceUtil = util = new ResourceVariableUtil(resource);
            });
        }
    }

    private void initAppFolder(IResource resource) {
        this.appFolder = resource;
        this.appFolderrUtil = new ResourceVariableUtil(this.selectedResourceUtil, resource);
        Map<String, IStringVariable> variables = this.getVariables();
        VariableUtils.add(variables, (Collection)ResourceVariables.getSingleResourceVariables(), (IDynamicVariableResolver)new ResourceVariableResolver((ResourceVariableResolver.Context)this.appFolderrUtil));
    }

    public IResource getAppFolder() {
        return this.appFolder;
    }

    public IWorkbenchPage getWorkbenchPage() {
        return this.appFolderrUtil.getWorkbenchPage();
    }

    public void initAddress(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
        this.appHost = configuration.getAttribute("org.eclipse.statet.r.apps/App.host", "");
        this.appPort = configuration.getAttribute("org.eclipse.statet.r.apps/App.port", 0);
        Map<String, IStringVariable> variables = this.getVariables();
        VariableUtils.add(variables, (IStringVariable)AppControlConfigs.APP_HOST_VAR);
        VariableUtils.add(variables, (IStringVariable)AppControlConfigs.APP_PORT_VAR);
    }

    public String getAppHost() {
        return this.appHost;
    }

    public int getAppPort() {
        return this.appPort;
    }

    public void initOperation(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
        this.stopBlocking = configuration.getAttribute("org.eclipse.statet.r.apps/Start.StopBlockingTasks.mode", 0);
        String code = configuration.getAttribute("org.eclipse.statet.r.apps/Start.RSnippet.code", "");
        if (code.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.apps", Messages.Operation_StartApp_RCode_error_SpecMissing_message));
        }
        try {
            VariableText2 variableResolver = new VariableText2(this.getVariables());
            variableResolver.validate(code, VariableText2.Severities.CHECK_SYNTAX, null);
            this.startCode = code;
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.apps", NLS.bind((String)Messages.Operation_StartApp_RCode_error_SpecInvalid_message, (Object)e.getMessage())));
        }
        code = configuration.getAttribute("org.eclipse.statet.r.apps/Stop.RSnippet.code", "");
        this.stopCode = !code.isEmpty() ? code : null;
        this.viewerId = configuration.getAttribute("org.eclipse.statet.r.apps/Viewer.id", null);
        code = configuration.getAttribute("org.eclipse.statet.r.apps/Variables.code", "");
        if (code.isEmpty()) {
            code = null;
        }
        this.variablesCode = code;
        String viewAction = configuration.getAttribute("org.eclipse.statet.r.apps/Variables.Viewer.action", "");
        int viewActionMode = 0;
        if (viewAction.equals("show")) {
            viewActionMode = 2;
        }
        this.variablesViewAction = viewActionMode;
    }

    public int getStopBlocking() {
        return this.stopBlocking;
    }

    public String getStartCode() {
        return this.startCode;
    }

    public String getStopCode() {
        return this.stopCode;
    }

    public @Nullable String getViewerId() {
        return this.viewerId;
    }

    public @Nullable String getVariablesCode() {
        return this.variablesCode;
    }

    public int getVariablesViewAction() {
        return this.variablesViewAction;
    }
}

