/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.NotNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ReferencedTablesVisitor;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class ValueNode
extends QueryTreeNode {
    private DataTypeDescriptor dataTypeServices;
    boolean transformed;

    ValueNode(ContextManager cm) {
        super(cm);
    }

    final void setType(TypeId typeId, boolean isNullable, int maximumWidth) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, isNullable, maximumWidth));
    }

    final void setType(TypeId typeId, int precision, int scale, boolean isNullable, int maximumWidth) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, precision, scale, isNullable, maximumWidth));
    }

    @Override
    public String toString() {
        return "dataTypeServices: " + (this.dataTypeServices != null ? this.dataTypeServices.toString() : "null") + "\n" + super.toString();
    }

    DataTypeDescriptor getTypeServices() {
        return this.dataTypeServices;
    }

    public void setNullability(boolean nullability) throws StandardException {
        this.setType(this.getTypeServices().getNullabilityType(nullability));
    }

    public void setCollationInfo(DataTypeDescriptor collationInfoType) throws StandardException {
        this.setCollationInfo(collationInfoType.getCollationType(), collationInfoType.getCollationDerivation());
    }

    public void setCollationInfo(int collationType, int collationDerivation) throws StandardException {
        this.setType(this.getTypeServices().getCollatedType(collationType, collationDerivation));
    }

    TypeId getTypeId() throws StandardException {
        DataTypeDescriptor dtd = this.getTypeServices();
        if (dtd != null) {
            return dtd.getTypeId();
        }
        return null;
    }

    protected final DataValueFactory getDataValueFactory() {
        return this.getLanguageConnectionContext().getDataValueFactory();
    }

    final TypeCompiler getTypeCompiler() throws StandardException {
        return this.getTypeCompiler(this.getTypeId());
    }

    void setType(DataTypeDescriptor dataTypeServices) throws StandardException {
        if (dataTypeServices != null) {
            dataTypeServices = this.bindUserType(dataTypeServices);
        }
        this.dataTypeServices = dataTypeServices;
        if (dataTypeServices != null) {
            this.createTypeDependency(dataTypeServices);
        }
    }

    protected final void setCollationUsingCompilationSchema() throws StandardException {
        this.setCollationUsingCompilationSchema(1);
    }

    protected final void setCollationUsingCompilationSchema(int collationDerivation) throws StandardException {
        this.setCollationInfo(this.getSchemaDescriptor(null, false).getCollationType(), collationDerivation);
    }

    ResultColumn getSourceResultColumn() {
        return null;
    }

    void setTransformed() {
        this.transformed = true;
    }

    boolean getTransformed() {
        return this.transformed;
    }

    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        return this.bindExpression(fromList, subqueryList, aggregates, false);
    }

    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates, boolean forQueryRewrite) throws StandardException {
        SanityManager.ASSERT(false, "bindExpression() not expected to be called on a " + this.getClass().toString());
        return this;
    }

    ValueNode genSQLJavaSQLTree() throws StandardException {
        SanityManager.ASSERT(this.getTypeId() != null, "genSQLJavaSQLTree() only expected to be called on a bound node");
        SanityManager.ASSERT(this.getTypeId().userType(), "genSQLJavaSQLTree() only expected to be called on user types");
        ContextManager cm = this.getContextManager();
        SQLToJavaValueNode stjvn = new SQLToJavaValueNode(this, cm);
        JavaToSQLValueNode jtsvn = new JavaToSQLValueNode(stjvn, cm);
        DataTypeDescriptor resultType = this.getTypeServices() != null && this.getTypeId().userType() ? this.getTypeServices() : DataTypeDescriptor.getSQLDataTypeDescriptor(((JavaValueNode)stjvn).getJavaTypeName());
        jtsvn.setType(resultType);
        return jtsvn;
    }

    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        return this;
    }

    ValueNode evaluateConstantExpressions() throws StandardException {
        return this;
    }

    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        if (!underNotNode) {
            return this;
        }
        SanityManager.ASSERT(this.getTypeId().isBooleanTypeId(), "Node's type (" + this.getTypeId().getSQLTypeName() + ") is expected to be boolean");
        return this.genEqualsFalseTree();
    }

    ValueNode genEqualsFalseTree() throws StandardException {
        BooleanConstantNode falseNode = new BooleanConstantNode(false, this.getContextManager());
        BinaryRelationalOperatorNode equalsNode = new BinaryRelationalOperatorNode(0, this, falseNode, false, this.getContextManager());
        boolean nullableResult = this.getTypeServices().isNullable();
        equalsNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult));
        return equalsNode;
    }

    ValueNode genIsNullTree(boolean notNull) throws StandardException {
        IsNullNode isNullNode = new IsNullNode(this, notNull, this.getContextManager());
        isNullNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, false));
        return isNullNode;
    }

    boolean verifyEliminateNots() {
        return !(this instanceof NotNode);
    }

    ValueNode putAndsOnTop() throws StandardException {
        BooleanConstantNode trueNode = new BooleanConstantNode(true, this.getContextManager());
        AndNode andNode = new AndNode(this, trueNode, this.getContextManager());
        andNode.postBindFixup();
        return andNode;
    }

    boolean verifyPutAndsOnTop() {
        return true;
    }

    ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        return this;
    }

    boolean verifyChangeToCNF() {
        return true;
    }

    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return true;
    }

    String getSchemaName() throws StandardException {
        return null;
    }

    String getTableName() {
        return null;
    }

    public boolean updatableByCursor() {
        return false;
    }

    String getColumnName() {
        return null;
    }

    JBitSet getTablesReferenced() throws StandardException {
        ReferencedTablesVisitor rtv = new ReferencedTablesVisitor(new JBitSet(0));
        this.accept(rtv);
        return rtv.getTableMap();
    }

    boolean isCloneable() {
        return false;
    }

    ValueNode getClone() throws StandardException {
        SanityManager.ASSERT(false, "getClone() not expected to be called for " + this.getClass().getName());
        return null;
    }

    void copyFields(ValueNode oldVN) throws StandardException {
        this.dataTypeServices = oldVN.getTypeServices();
    }

    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        return this;
    }

    boolean isConstantExpression() {
        return false;
    }

    boolean constantExpression(PredicateList whereClause) {
        return false;
    }

    protected int getOrderableVariantType() throws StandardException {
        return 0;
    }

    public ValueNode checkIsBoolean() throws StandardException {
        ValueNode whereClause = this;
        TypeId whereTypeId = whereClause.getTypeId();
        if (whereTypeId.userType()) {
            whereClause = whereClause.genSQLJavaSQLTree();
            whereTypeId = whereClause.getTypeId();
        }
        if (!whereTypeId.equals(TypeId.BOOLEAN_ID)) {
            throw StandardException.newException("42X19.S.1", whereTypeId.getSQLTypeName());
        }
        return whereClause;
    }

    Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    @Override
    final void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateExpression(acb, mb);
    }

    public double selectivity(Optimizable optTable) throws StandardException {
        if (this.transformed) {
            return 1.0;
        }
        return 0.5;
    }

    void checkTopPredicatesForEqualsConditions(int tableNumber, boolean[] eqOuterCols, int[] tableNumbers, JBitSet[] tableColMap, boolean resultColTable) throws StandardException {
        ValueNode whereWalker = this;
        while (whereWalker instanceof AndNode) {
            AndNode and = (AndNode)whereWalker;
            if (and.getLeftOperand().isRelationalOperator() && ((RelationalOperator)((Object)and.getLeftOperand())).getOperator() == 1) {
                int resultTable;
                BinaryRelationalOperatorNode beon = (BinaryRelationalOperatorNode)and.getLeftOperand();
                ValueNode left = beon.getLeftOperand();
                ValueNode right = beon.getRightOperand();
                if (resultColTable) {
                    for (resultTable = 0; resultTable < tableNumbers.length && tableNumbers[resultTable] != tableNumber; ++resultTable) {
                    }
                } else {
                    resultTable = -1;
                }
                if (left instanceof ColumnReference && ((ColumnReference)left).getTableNumber() == tableNumber) {
                    this.updateMaps(tableColMap, eqOuterCols, tableNumbers, tableNumber, resultTable, right, left);
                } else if (right instanceof ColumnReference && ((ColumnReference)right).getTableNumber() == tableNumber) {
                    this.updateMaps(tableColMap, eqOuterCols, tableNumbers, tableNumber, resultTable, left, right);
                }
            }
            whereWalker = ((AndNode)whereWalker).getRightOperand();
        }
    }

    boolean isBooleanTrue() {
        return false;
    }

    boolean isBooleanFalse() {
        return false;
    }

    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(false, "Code generation for this type of ValueNode is unimplemented");
    }

    private void updateMaps(JBitSet[] tableColMap, boolean[] eqOuterCols, int[] tableNumbers, int tableNumber, int resultTable, ValueNode arg1, ValueNode arg2) throws StandardException {
        if (arg1 instanceof ConstantNode || arg1.requiresTypeFromContext()) {
            this.setValueCols(tableColMap, eqOuterCols, ((ColumnReference)arg2).getColumnNumber(), resultTable);
        } else if (arg1 instanceof ColumnReference && ((ColumnReference)arg1).getTableNumber() != tableNumber) {
            int index;
            int otherTN = ((ColumnReference)arg1).getTableNumber();
            int colNumber = ((ColumnReference)arg2).getColumnNumber();
            for (index = 0; index < tableNumbers.length && otherTN != tableNumbers[index]; ++index) {
            }
            if (index == tableNumbers.length) {
                this.setValueCols(tableColMap, eqOuterCols, colNumber, resultTable);
            } else if (tableColMap != null) {
                tableColMap[index].set(colNumber);
            }
        } else {
            int index;
            JBitSet referencedTables = arg1.getTablesReferenced();
            int colNumber = ((ColumnReference)arg2).getColumnNumber();
            for (index = 0; index < tableNumbers.length && !referencedTables.get(tableNumbers[index]); ++index) {
            }
            if (index == tableNumbers.length) {
                this.setValueCols(tableColMap, eqOuterCols, colNumber, resultTable);
            } else if (tableColMap != null && !referencedTables.get(tableNumber)) {
                tableColMap[index].set(colNumber);
            }
        }
    }

    private void setValueCols(JBitSet[] tableColMap, boolean[] eqOuterCols, int colReference, int resultTable) {
        if (eqOuterCols != null) {
            eqOuterCols[colReference] = true;
        }
        if (tableColMap != null) {
            if (resultTable == -1) {
                for (int i = 0; i < tableColMap.length; ++i) {
                    tableColMap[i].set(colReference);
                }
            } else {
                tableColMap[resultTable].set(colReference);
            }
        }
    }

    boolean isRelationalOperator() {
        return false;
    }

    boolean isBinaryEqualsOperatorNode() {
        return false;
    }

    boolean isInListProbeNode() {
        return false;
    }

    boolean optimizableEqualityNode(Optimizable optTable, int columnNumber, boolean isNullOkay) throws StandardException {
        return false;
    }

    boolean requiresTypeFromContext() {
        return false;
    }

    boolean isParameterNode() {
        return false;
    }

    abstract boolean isEquivalent(ValueNode var1) throws StandardException;

    boolean isSameNodeKind(ValueNode other) {
        return other != null && other.getClass().equals(this.getClass());
    }
}

