/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditor;

public class FoldingActionGroup
extends ActionGroup
implements IProjectionListener {
    private ITextEditor editor;
    private ProjectionViewer viewer;
    private final ViewerOperationHandler expand;
    private final ViewerOperationHandler collapse;
    private final ViewerOperationHandler expandAll;
    private final ViewerOperationHandler collapseAll;

    public FoldingActionGroup(ITextEditor editor, ProjectionViewer viewer) {
        this.editor = editor;
        this.viewer = viewer;
        IHandlerService handlerService = (IHandlerService)this.editor.getSite().getService(IHandlerService.class);
        this.expandAll = new ViewerOperationHandler(20);
        handlerService.activateHandler("org.eclipse.ui.edit.text.folding.expand_all", (IHandler)this.expandAll);
        this.collapseAll = new ViewerOperationHandler(21);
        handlerService.activateHandler("org.eclipse.ui.edit.text.folding.collapse_all", (IHandler)this.collapseAll);
        this.expand = new ViewerOperationHandler(17);
        handlerService.activateHandler("org.eclipse.ui.edit.text.folding.expand", (IHandler)this.expand);
        this.collapse = new ViewerOperationHandler(18);
        handlerService.activateHandler("org.eclipse.ui.edit.text.folding.collapse", (IHandler)this.collapse);
        this.viewer.addProjectionListener((IProjectionListener)this);
        this.update();
    }

    public void dispose() {
        this.editor = null;
        this.viewer = null;
        super.dispose();
    }

    protected void update() {
        if (this.viewer != null) {
            this.expand.update();
            this.expandAll.update();
            this.collapse.update();
            this.collapseAll.update();
        }
    }

    public void fillMenu(IMenuManager menuManager) {
        if (this.viewer != null) {
            this.update();
            IWorkbenchPartSite site = this.editor.getSite();
            menuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.ui.edit.text.folding.toggle", null, null, null, null, EditingMessages.CodeFolding_Enable_label, EditingMessages.CodeFolding_Enable_mnemonic, null, 32, null, false)));
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.ui.edit.text.folding.expand_all", null, null, null, null, EditingMessages.CodeFolding_ExpandAll_label, EditingMessages.CodeFolding_ExpandAll_mnemonic, null, 32, null, false), (IHandler2)this.expandAll));
            menuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.ui.edit.text.folding.collapse_all", null, null, null, null, EditingMessages.CodeFolding_CollapseAll_label, EditingMessages.CodeFolding_CollapseAll_mnemonic, null, 32, null, false), (IHandler2)this.collapseAll));
        }
    }

    public void updateActionBars() {
        this.update();
    }

    public void projectionEnabled() {
        this.update();
    }

    public void projectionDisabled() {
        this.update();
    }

    private class ViewerOperationHandler
    extends AbstractHandler {
        private final int operationCode;

        public ViewerOperationHandler(int operationCode) {
            this.operationCode = operationCode;
        }

        public void update() {
            this.setBaseEnabled(UIAccess.isOkToUse((Viewer)FoldingActionGroup.this.viewer) && FoldingActionGroup.this.viewer.isProjectionMode());
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            if (UIAccess.isOkToUse((Viewer)FoldingActionGroup.this.viewer) && FoldingActionGroup.this.viewer.canDoOperation(this.operationCode)) {
                FoldingActionGroup.this.viewer.doOperation(this.operationCode);
            }
            return null;
        }
    }
}

