/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.eclipse.statet.internal.jcommons.collections.AbstractImLongList;
import org.eclipse.statet.jcommons.collections.LongList;
import org.eclipse.statet.jcommons.collections.LongListIterator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ImLongArrayList
extends AbstractImLongList {
    private final long[] array;

    public ImLongArrayList(long[] array) {
        this.array = array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(long e) {
        return this.indexOf(e) >= 0;
    }

    @Override
    public long getAt(int index) {
        if (index < 0 || index >= this.array.length) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.array[index];
    }

    @Override
    public long getFirst() {
        return this.array[0];
    }

    @Override
    public long getLast() {
        return this.array[this.array.length - 1];
    }

    @Override
    public int indexOf(long e) {
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i] == e) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long e) {
        int i = this.array.length - 1;
        while (i >= 0) {
            if (this.array[i] == e) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public LongListIterator iterator() {
        return new Iter(0);
    }

    @Override
    public LongListIterator listIterator(int index) {
        if (index < 0 || index > this.array.length) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return new Iter(index);
    }

    @Override
    public LongStream stream() {
        return StreamSupport.longStream(Spliterators.spliterator(this.array, 1040), false);
    }

    @Override
    public long[] toArray() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    @Override
    public void toArray(long[] array) {
        System.arraycopy(this.array, 0, array, 0, this.array.length);
    }

    @Override
    public void copyTo(int srcIndex, long[] dest, int destIndex, int length) {
        System.arraycopy(this.array, srcIndex, dest, destIndex, length);
    }

    @Override
    public void copyTo(long[] dest, int destIndex) {
        System.arraycopy(this.array, 0, dest, destIndex, this.array.length);
    }

    public int hashCode() {
        int hashCode = 7;
        int i = 0;
        while (i < this.array.length) {
            hashCode = 31 * hashCode + Long.hashCode(this.array[i]);
            ++i;
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongList) {
            LongList other = (LongList)obj;
            if (this.array.length != other.size()) {
                return false;
            }
            int i = 0;
            while (i < this.array.length) {
                if (this.array[i] != other.getAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    private class Iter
    extends AbstractImLongList.AbstractImLongListIter {
        private int cursor;

        Iter(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ImLongArrayList.this.array.length;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public long nextLong() {
            if (this.cursor >= ImLongArrayList.this.array.length) {
                throw new NoSuchElementException();
            }
            return ImLongArrayList.this.array[this.cursor++];
        }

        @Override
        public Long next() {
            if (this.cursor >= ImLongArrayList.this.array.length) {
                throw new NoSuchElementException();
            }
            return ImLongArrayList.this.array[this.cursor++];
        }

        @Override
        public long nextLongElse(long elseLong) {
            if (this.cursor >= ImLongArrayList.this.array.length) {
                return elseLong;
            }
            return ImLongArrayList.this.array[this.cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public long previousLong() {
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            return ImLongArrayList.this.array[--this.cursor];
        }

        @Override
        public Long previous() {
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            return ImLongArrayList.this.array[--this.cursor];
        }
    }
}

