/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.graphic.core;

import org.eclipse.statet.jcommons.graphic.core.ColorDef;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class HSVColorDef
extends ColorDef {
    protected final float hue;
    protected final float saturation;
    protected final float value;

    protected static int checkHSV(float hue, float saturation, float value) {
        float r;
        float g;
        float b;
        if (hue < 0.0f || hue > 1.0f) {
            throw new IllegalArgumentException("hue");
        }
        if (saturation < 0.0f || saturation > 1.0f) {
            throw new IllegalArgumentException("saturation");
        }
        if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException("value");
        }
        if (saturation == 0.0f) {
            g = b = value;
            r = b;
        } else {
            if (hue == 1.0f) {
                hue = 0.0f;
            }
            int i = (int)(hue *= 6.0f);
            float f = hue - (float)i;
            float p = value * (1.0f - saturation);
            float q = value * (1.0f - saturation * f);
            float t = value * (1.0f - saturation * (1.0f - f));
            switch (i) {
                case 0: {
                    r = value;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = value;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = value;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = value;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = value;
                    break;
                }
                default: {
                    r = value;
                    g = p;
                    b = q;
                }
            }
        }
        return (int)(r * 255.0f + 0.5f) | (int)(g * 255.0f + 0.5f) << 8 | (int)(b * 255.0f + 0.5f) << 16;
    }

    public HSVColorDef(float hue, float saturation, float value) {
        super(HSVColorDef.checkHSV(hue, saturation, value));
        this.hue = HSVColorDef.round1(hue);
        this.saturation = HSVColorDef.round1(saturation);
        this.value = HSVColorDef.round1(value);
    }

    public HSVColorDef(ColorDef def) {
        super(def);
        if (def instanceof HSVColorDef) {
            HSVColorDef other = (HSVColorDef)def;
            this.hue = other.hue;
            this.saturation = other.saturation;
            this.value = other.value;
        } else {
            float r = (float)this.getRed() / 255.0f;
            float g = (float)this.getGreen() / 255.0f;
            float b = (float)this.getBlue() / 255.0f;
            float max = Math.max(Math.max(r, g), b);
            float min = Math.min(Math.min(r, g), b);
            float delta = max - min;
            float hue = 0.0f;
            if (delta != 0.0f) {
                hue = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
                if ((hue /= 6.0f) < 0.0f) {
                    hue += 1.0f;
                }
            }
            this.hue = HSVColorDef.round1(hue);
            this.saturation = HSVColorDef.round1(max == 0.0f ? 0.0f : (max - min) / max);
            this.value = HSVColorDef.round1(max);
        }
    }

    @Override
    public String getType() {
        return "HSV";
    }

    public float getHue() {
        return this.hue;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (this == obj) break block2;
                if (!(obj instanceof HSVColorDef)) break block3;
                HSVColorDef other = (HSVColorDef)obj;
                if (this.hue == other.hue && this.saturation == other.saturation && this.value == other.value) break block2;
            }
            return false;
        }
        return true;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("HSV= ");
        sb.append(this.hue);
        sb.append(", ");
        sb.append(this.saturation);
        sb.append(", ");
        sb.append(this.value);
        sb.append(" (#");
        sb.append(this.getRGBHexString());
        sb.append(')');
    }
}

