/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.eclient.graphics;

import java.util.Collections;
import java.util.List;
import org.eclipse.statet.internal.rj.eclient.graphics.GraphicInitialization;
import org.eclipse.statet.rj.eclient.graphics.DefaultGCRenderer;
import org.eclipse.statet.rj.eclient.graphics.ERGraphicInstruction;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class RGraphicCanvas
extends Canvas
implements PaintListener {
    public static final List<ERGraphicInstruction> NO_GRAPHIC = Collections.emptyList();
    private List<? extends ERGraphicInstruction> graphicInstructions = Collections.emptyList();
    private final DefaultGCRenderer renderer = new DefaultGCRenderer();
    private GraphicInitialization init;

    public RGraphicCanvas(Composite parent) {
        super(parent, RGraphicCanvas.checkStyle(0));
        this.addPaintListener(this);
    }

    private static int checkStyle(int style) {
        style |= 0x140000;
        return style |= 0x20000000;
    }

    public void setInstructions(List<? extends ERGraphicInstruction> graphicData) {
        this.graphicInstructions = graphicData;
        this.init = !this.graphicInstructions.isEmpty() ? (GraphicInitialization)this.graphicInstructions.get(0) : null;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GraphicInitialization init = this.init;
        if (init != null) {
            return new Point((int)(init.width + 0.5), (int)(init.height + 0.5));
        }
        return super.computeSize(wHint, hHint, changed);
    }

    public double widget2graphicsX(double x) {
        return x;
    }

    public double widget2graphicY(double y) {
        return y;
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Rectangle clientArea = this.getClientArea();
        gc.setBackground(gc.getDevice().getSystemColor(22));
        gc.fillRectangle(0, 0, clientArea.width, clientArea.height);
        if (this.graphicInstructions.isEmpty()) {
            return;
        }
        this.renderer.clear(1.0);
        this.renderer.paint(gc, this.graphicInstructions);
    }
}

