/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.eclient.graphics.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.rj.eclient.graphics.ERGraphic;
import org.eclipse.statet.rj.eclient.graphics.LocatorCallback;
import org.eclipse.statet.rj.ts.core.RTool;

public abstract class AbstractLocalLocator
extends LocatorCallback
implements SystemRunnable {
    protected static final ImList<String> OK_CANCEL_STOP_TYPES = ImCollections.newList((Object[])new String[]{"done", "cancel"});
    private final ERGraphic graphic;
    private final RTool tool;
    private boolean started;
    private boolean graphicLocatorStarted;
    private boolean runnableScheduled;
    private final List<double[]> toConvert = new ArrayList<double[]>();
    private final List<double[]> locatedGraphic = new ArrayList<double[]>();
    private final List<double[]> locatedUser = new ArrayList<double[]>();
    private volatile int counter;

    public AbstractLocalLocator(ERGraphic graphic) {
        this.graphic = graphic;
        this.tool = graphic.getRHandle();
    }

    @Override
    public Collection<String> getStopTypes() {
        return OK_CANCEL_STOP_TYPES;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + " (" + this.counter + " selected)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int located(double x, double y) {
        AbstractLocalLocator abstractLocalLocator = this;
        synchronized (abstractLocalLocator) {
            block4: {
                ++this.counter;
                this.toConvert.add(new double[]{x, y});
                if (this.internalScheduleConversion()) break block4;
                this.internalStop(null);
                return 0;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopped(String type) {
        AbstractLocalLocator abstractLocalLocator = this;
        synchronized (abstractLocalLocator) {
            this.graphicLocatorStarted = false;
            if (type == "done") {
                if (this.toConvert.isEmpty()) {
                    this.internalStop("done");
                    return;
                }
                if (this.internalScheduleConversion()) {
                    return;
                }
            }
            this.internalStop(null);
            return;
        }
    }

    public String getTypeId() {
        return "r/rjgd/locallocator";
    }

    public String getLabel() {
        return "Resolve Graphic Points";
    }

    public boolean canRunIn(Tool tool) {
        return tool == this.tool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changed(int event, Tool tool) {
        switch (event) {
            case 288: {
                return false;
            }
            case 290: 
            case 340: 
            case 344: {
                AbstractLocalLocator abstractLocalLocator = this;
                synchronized (abstractLocalLocator) {
                    this.runnableScheduled = false;
                    if (!this.graphicLocatorStarted) {
                        this.internalStop(null);
                        break;
                    }
                }
                this.graphic.stopLocator(null);
                break;
            }
            case 336: {
                AbstractLocalLocator abstractLocalLocator = this;
                synchronized (abstractLocalLocator) {
                    if (!this.graphicLocatorStarted && this.toConvert.isEmpty()) {
                        this.internalStop("done");
                    }
                    break;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ToolService service, ProgressMonitor m) throws StatusException {
        double[] graphic = null;
        double[] user = null;
        while (true) {
            AbstractLocalLocator abstractLocalLocator = this;
            synchronized (abstractLocalLocator) {
                if (graphic != null && user != null) {
                    this.locatedGraphic.add(graphic);
                    this.locatedUser.add(user);
                }
                if (this.toConvert.isEmpty()) {
                    this.counter = this.locatedGraphic.size();
                    this.runnableScheduled = false;
                    return;
                }
                graphic = this.toConvert.remove(0);
                user = null;
            }
            user = this.graphic.convertGraphic2User(graphic, m);
        }
    }

    protected boolean internalScheduleConversion() {
        if (!this.runnableScheduled) {
            if (this.tool.getQueue().addHot((ToolRunnable)this).getSeverity() == 0) {
                this.runnableScheduled = true;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void internalStop(String type) {
        assert (!this.graphicLocatorStarted);
        if (this.runnableScheduled) {
            this.tool.getQueue().removeHot((ToolRunnable)this);
            this.runnableScheduled = false;
        }
        this.started = false;
        if (type == "done") {
            this.finished(new ArrayList<double[]>(this.locatedGraphic), new ArrayList<double[]>(this.locatedUser));
        } else {
            this.canceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        AbstractLocalLocator abstractLocalLocator = this;
        synchronized (abstractLocalLocator) {
            block6: {
                block5: {
                    if (!this.started) break block5;
                    return false;
                }
                this.toConvert.clear();
                this.locatedGraphic.clear();
                this.locatedUser.clear();
                this.graphicLocatorStarted = true;
                this.started = true;
                this.counter = 0;
                if (this.graphic.startLocalLocator(this).getSeverity() != 0) break block6;
                return true;
            }
            this.graphicLocatorStarted = false;
            this.started = false;
            return false;
        }
    }

    protected abstract void finished(List<double[]> var1, List<double[]> var2);

    protected abstract void canceled();
}

