/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.ui.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.statet.jcommons.ts.core.ToolCommandHandler;
import org.eclipse.statet.nico.core.runtime.HistoryOperationsHandler;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.ui.setup.ChooseFileHandler;
import org.eclipse.statet.nico.ui.setup.EclipseIDEOperationsHandler;
import org.eclipse.statet.nico.ui.setup.OpenWebBrowserHandler;
import org.eclipse.statet.nico.ui.setup.QuitHandler;
import org.eclipse.statet.nico.ui.setup.ReportStatusHandler;
import org.eclipse.statet.nico.ui.setup.RunBlockingHandler;
import org.eclipse.statet.r.console.core.AbstractRController;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.ui.dataeditor.ShowRElementCommandHandler;
import org.eclipse.statet.r.ui.graphics.RGraphicCommandHandler;
import org.eclipse.statet.r.ui.pkgmanager.RPkgUICommandHandler;
import org.eclipse.statet.r.ui.rhelp.RHelpUICommandHandler;
import org.eclipse.statet.r.ui.rtool.setup.RShowContentsCommandHandler;

public class RConsoleLaunching {
    public static final String R_CONSOLE_CONFIGURATION_TYPE_ID = "org.eclipse.statet.r.launchConfigurations.RConsole";
    public static final String R_REMOTE_CONSOLE_CONFIGURATION_TYPE_ID = "org.eclipse.statet.r.launchConfigurations.RRemoteConsole";
    public static final String R_CONSOLE_PROCESS_TYPE = "R.nico";
    public static final String LOCAL_RTERM = "local.rterm";
    public static final String LOCAL_RJS = "local.rjs-rmi";
    public static final String REMOTE_RJS = "remote.rjs-rmi";
    public static final String REMOTE_RJS_RECONNECT = "remote.rjs-rmi-reconnect";
    public static final String REMOTE_RJS_SSH = "remote.rjs-rmi.ssh";
    static final String ATTR_ROOT = "org.eclipse.statet.r.debug/RConsole/";
    public static final String ATTR_TYPE = "org.eclipse.statet.r.debug/RConsole/type";
    public static final String ATTR_OPTIONS = "org.eclipse.statet.r.debug/RConsole/arguments.options";
    public static final String ATTR_ADDRESS = "org.eclipse.statet.r.debug/RConsole/address";
    public static final String ATTR_PIN_CONSOLE = "org.eclipse.statet.r.debug/RConsole/console.pin";
    public static final String ATTR_SSH_PORT = "org.eclipse.statet.r.debug/RConsole/ssh.port";
    public static final String ATTR_SSH_TUNNEL_ENABLED = "org.eclipse.statet.r.debug/RConsole/ssh.tunnel.enabled";
    public static final String ATTR_COMMAND = "org.eclipse.statet.r.debug/RConsole/command";
    public static final String ATTR_LOGIN_NAME = "org.eclipse.statet.r.debug/RConsole/login.name";
    public static final String ATTR_INIT_SCRIPT_SNIPPET = "org.eclipse.statet.r.debug/RConsole/init.script.snippet";
    public static final String ATTR_OBJECTDB_ENABLED = "org.eclipse.statet.r.debug/RConsole/objectdb.enabled";
    public static final String ATTR_OBJECTDB_AUTOREFRESH_ENABLED = "org.eclipse.statet.r.debug/RConsole/objectdb.autorefresh.enabled";
    public static final String ATTR_OBJECTDB_LISTS_MAX_LENGTH = "org.eclipse.statet.r.debug/RConsole/objectdb.lists.max_length";
    public static final String ATTR_OBJECTDB_ENVS_MAX_LENGTH = "org.eclipse.statet.r.debug/RConsole/objectdb.envs.max_length";

    public static void registerDefaultHandlerTo(AbstractRController controller) {
        controller.addCommandHandler("common/scheduleQuit", (ToolCommandHandler)new QuitHandler());
        controller.addCommandHandler("common/runBlocking", (ToolCommandHandler)new RunBlockingHandler());
        controller.addCommandHandler("common/reportStatus", (ToolCommandHandler)new ReportStatusHandler());
        HistoryOperationsHandler handler = new HistoryOperationsHandler();
        controller.addCommandHandler("console/loadHistory", (ToolCommandHandler)handler);
        controller.addCommandHandler("console/saveHistory", (ToolCommandHandler)handler);
        controller.addCommandHandler("console/addtoHistory", (ToolCommandHandler)handler);
        handler = new ChooseFileHandler();
        controller.addCommandHandler("common/chooseFile", (ToolCommandHandler)handler);
        handler = new EclipseIDEOperationsHandler();
        controller.addCommandHandler("common/openFile", (ToolCommandHandler)handler);
        controller.addCommandHandler("common/showFile", (ToolCommandHandler)handler);
        controller.addCommandHandler("common/showHistory", (ToolCommandHandler)handler);
        handler = new ShowRElementCommandHandler();
        controller.addCommandHandler("r/showElement", (ToolCommandHandler)handler);
        controller.addCommandHandler("showElement", (ToolCommandHandler)handler);
        handler = new RGraphicCommandHandler();
        controller.addCommandHandler("r/initRGraphicFactory", (ToolCommandHandler)handler);
        handler = new RShowContentsCommandHandler();
        controller.addCommandHandler("r/showContents", (ToolCommandHandler)handler);
        handler = new OpenWebBrowserHandler(controller.getWorkspace().isRemote());
        controller.addCommandHandler("common/openWebBrowser", (ToolCommandHandler)handler);
        handler = new RHelpUICommandHandler();
        controller.addCommandHandler("org.eclipse.statet.r.rhelp.showHelp", (ToolCommandHandler)handler);
        controller.addCommandHandler("showHelp", (ToolCommandHandler)handler);
        if (controller.getTool().getREnv() != null) {
            handler = new RPkgUICommandHandler();
            controller.addCommandHandler("openPackageManager", (ToolCommandHandler)handler);
        }
    }

    public static void scheduleStartupSnippet(AbstractRController controller, ILaunchConfiguration configuration) throws CoreException {
        String snippet = configuration.getAttribute(ATTR_INIT_SCRIPT_SNIPPET, null);
        if (snippet != null && snippet.length() > 0) {
            String[] lines;
            String[] stringArray = lines = RUtil.LINE_SEPARATOR_PATTERN.split(snippet);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                controller.addStartupRunnable(controller.createCommandRunnable(line, SubmitType.TOOLS));
                ++n2;
            }
        }
    }
}

