/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.data.IDataProvider;
import org.eclipse.statet.ecommons.waltable.data.ISpanningDataProvider;
import org.eclipse.statet.ecommons.waltable.layer.cell.DataCell;
import org.eclipse.statet.ecommons.waltable.persistence.IPersistable;

public class AutomaticSpanningDataProvider
implements ISpanningDataProvider,
IPersistable {
    public static final String PERSISTENCE_KEY_AUTO_COLUMN_SPAN = ".autoColumnSpan";
    public static final String PERSISTENCE_KEY_AUTO_ROW_SPAN = ".autoRowSpan";
    public static final String PERSISTENCE_KEY_AUTO_SPAN_COLUMNS = ".autoSpanColumns";
    public static final String PERSISTENCE_KEY_AUTO_SPAN_ROWS = ".autoSpanRows";
    private final IDataProvider underlyingDataProvider;
    private boolean autoColumnSpan;
    private boolean autoRowSpan;
    private final List<Long> autoSpanColumns = new ArrayList<Long>();
    private final List<Long> autoSpanRows = new ArrayList<Long>();

    public AutomaticSpanningDataProvider(IDataProvider underlyingDataProvider, boolean autoColumnSpan, boolean autoRowSpan) {
        this.underlyingDataProvider = underlyingDataProvider;
        this.autoColumnSpan = autoColumnSpan;
        this.autoRowSpan = autoRowSpan;
    }

    @Override
    public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
        return this.underlyingDataProvider.getDataValue(columnIndex, rowIndex, flags, monitor);
    }

    @Override
    public void setDataValue(long columnIndex, long rowIndex, Object newValue) {
        this.underlyingDataProvider.setDataValue(columnIndex, rowIndex, newValue);
    }

    @Override
    public long getColumnCount() {
        return this.underlyingDataProvider.getColumnCount();
    }

    @Override
    public long getRowCount() {
        return this.underlyingDataProvider.getRowCount();
    }

    @Override
    public DataCell getCellByPosition(long columnPosition, long rowPosition) {
        long cellColumnPosition = this.isAutoSpanEnabledForColumn(columnPosition, rowPosition) ? this.getStartColumnPosition(columnPosition, rowPosition) : columnPosition;
        long cellRowPosition = this.isAutoSpanEnabledForRow(columnPosition, rowPosition) ? this.getStartRowPosition(columnPosition, rowPosition) : rowPosition;
        long columnSpan = this.isAutoSpanEnabledForColumn(columnPosition, rowPosition) ? this.getColumnSpan(cellColumnPosition, cellRowPosition) : 1L;
        long rowSpan = this.isAutoSpanEnabledForRow(columnPosition, rowPosition) ? this.getRowSpan(cellColumnPosition, cellRowPosition) : 1L;
        return new DataCell(cellColumnPosition, cellRowPosition, columnSpan, rowSpan);
    }

    protected boolean isAutoSpanEnabledForColumn(long columnPosition, long rowPosition) {
        return this.autoColumnSpan && this.isAutoSpanRow(rowPosition);
    }

    protected boolean isAutoSpanEnabledForRow(long columnPosition, long rowPosition) {
        return this.autoRowSpan && this.isAutoSpanColumn(columnPosition);
    }

    private boolean isAutoSpanColumn(long columnPosition) {
        return this.autoSpanColumns.isEmpty() || this.autoSpanColumns.contains(columnPosition);
    }

    private boolean isAutoSpanRow(long rowPosition) {
        return this.autoSpanRows.isEmpty() || this.autoSpanRows.contains(rowPosition);
    }

    public void addAutoSpanningColumnPositions(Long ... columnPositions) {
        this.autoSpanColumns.addAll(Arrays.asList(columnPositions));
    }

    public void addAutoSpanningRowPositions(Long ... rowPositions) {
        this.autoSpanRows.addAll(Arrays.asList(rowPositions));
    }

    public void removeAutoSpanningColumnPositions(Long ... columnPositions) {
        this.autoSpanColumns.removeAll(Arrays.asList(columnPositions));
    }

    public void removeAutoSpanningRowPositions(Long ... rowPositions) {
        this.autoSpanRows.removeAll(Arrays.asList(rowPositions));
    }

    public void clearAutoSpanningColumnPositions() {
        this.autoSpanColumns.clear();
    }

    public void clearAutoSpanningRowPositions() {
        this.autoSpanRows.clear();
    }

    protected long getStartColumnPosition(long columnPosition, long rowPosition) {
        Object before;
        if (columnPosition <= 0L || !this.isAutoSpanColumn(columnPosition) || !this.isAutoSpanColumn(columnPosition - 1L)) {
            return columnPosition;
        }
        Object current = this.getDataValue(columnPosition, rowPosition, 0, null);
        if (!Objects.equals(current, before = this.getDataValue(columnPosition - 1L, rowPosition, 0, null))) {
            return columnPosition;
        }
        return this.getStartColumnPosition(columnPosition - 1L, rowPosition);
    }

    protected long getStartRowPosition(long columnPosition, long rowPosition) {
        Object before;
        if (rowPosition <= 0L || !this.isAutoSpanRow(rowPosition) || !this.isAutoSpanRow(rowPosition - 1L)) {
            return rowPosition;
        }
        Object current = this.getDataValue(columnPosition, rowPosition, 0, null);
        if (!Objects.equals(current, before = this.getDataValue(columnPosition, rowPosition - 1L, 0, null))) {
            return rowPosition;
        }
        return this.getStartRowPosition(columnPosition, rowPosition - 1L);
    }

    protected long getColumnSpan(long columnPosition, long rowPosition) {
        long span = 1L;
        while (columnPosition < this.getColumnCount() - 1L && this.isAutoSpanColumn(columnPosition) && this.isAutoSpanColumn(columnPosition + 1L) && Objects.equals(this.getDataValue(columnPosition, rowPosition, 0, null), this.getDataValue(columnPosition + 1L, rowPosition, 0, null))) {
            ++span;
            ++columnPosition;
        }
        return span;
    }

    protected long getRowSpan(long columnPosition, long rowPosition) {
        long span = 1L;
        while (rowPosition < this.getRowCount() - 1L && this.isAutoSpanRow(rowPosition) && this.isAutoSpanRow(rowPosition + 1L) && Objects.equals(this.getDataValue(columnPosition, rowPosition, 0, null), this.getDataValue(columnPosition, rowPosition + 1L, 0, null))) {
            ++span;
            ++rowPosition;
        }
        return span;
    }

    public boolean isAutoColumnSpan() {
        return this.autoColumnSpan;
    }

    public void setAutoColumnSpan(boolean autoColumnSpan) {
        this.autoColumnSpan = autoColumnSpan;
    }

    public boolean isAutoRowSpan() {
        return this.autoRowSpan;
    }

    public void setAutoRowSpan(boolean autoRowSpan) {
        this.autoRowSpan = autoRowSpan;
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        StringBuilder strBuilder;
        properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_COLUMN_SPAN, Boolean.valueOf(this.autoColumnSpan).toString());
        properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_ROW_SPAN, Boolean.valueOf(this.autoRowSpan).toString());
        if (this.autoSpanColumns.size() > 0) {
            strBuilder = new StringBuilder();
            for (Long index : this.autoSpanColumns) {
                strBuilder.append(index);
                strBuilder.append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_SPAN_COLUMNS, strBuilder.toString());
        }
        if (this.autoSpanRows.size() > 0) {
            strBuilder = new StringBuilder();
            for (Long index : this.autoSpanRows) {
                strBuilder.append(index);
                strBuilder.append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_SPAN_ROWS, strBuilder.toString());
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String index;
        StringTokenizer tok;
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_COLUMN_SPAN);
        if (property != null) {
            this.autoColumnSpan = Boolean.valueOf(property);
        }
        if ((property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_ROW_SPAN)) != null) {
            this.autoRowSpan = Boolean.valueOf(property);
        }
        this.autoSpanColumns.clear();
        property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_SPAN_COLUMNS);
        if (property != null) {
            ArrayList<Long> newAutoSpanColumns = new ArrayList<Long>();
            tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                index = tok.nextToken();
                newAutoSpanColumns.add(Long.valueOf(index));
            }
            this.autoSpanColumns.addAll(newAutoSpanColumns);
        }
        this.autoSpanRows.clear();
        property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_SPAN_ROWS);
        if (property != null) {
            ArrayList<Long> newAutoSpanRows = new ArrayList<Long>();
            tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                index = tok.nextToken();
                newAutoSpanRows.add(Long.valueOf(index));
            }
            this.autoSpanRows.addAll(newAutoSpanRows);
        }
    }
}

