/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.data;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.data.IColumnAccessor;
import org.eclipse.statet.ecommons.waltable.data.IRowDataProvider;

public class ListDataProvider<T>
implements IRowDataProvider<T> {
    protected List<T> list;
    protected IColumnAccessor<T> columnAccessor;

    public ListDataProvider(List<T> list, IColumnAccessor<T> columnAccessor) {
        this.list = list;
        this.columnAccessor = columnAccessor;
    }

    @Override
    public long getColumnCount() {
        return this.columnAccessor.getColumnCount();
    }

    @Override
    public long getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
        if (rowIndex >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        T rowObj = this.list.get((int)rowIndex);
        return this.columnAccessor.getDataValue(rowObj, columnIndex);
    }

    @Override
    public void setDataValue(long columnIndex, long rowIndex, Object newValue) {
        if (rowIndex >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        T rowObj = this.list.get((int)rowIndex);
        this.columnAccessor.setDataValue(rowObj, columnIndex, newValue);
    }

    @Override
    public T getRowObject(long rowIndex) {
        if (rowIndex >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        return this.list.get((int)rowIndex);
    }

    @Override
    public long indexOfRowObject(T rowObject) {
        return this.list.indexOf(rowObject);
    }

    public List<T> getList() {
        return this.list;
    }
}

