/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.servi.pool;

import java.io.File;
import javax.management.OperationsException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.WarningStatus;
import org.eclipse.statet.rj.RjInitFailedException;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.util.RJContext;
import org.eclipse.statet.rj.servi.jmx.StandalonePoolServerMXBean;
import org.eclipse.statet.rj.servi.pool.JMPoolServer;

@NonNullByDefault
public class StandalonePoolServer
extends JMPoolServer
implements StandalonePoolServerMXBean {
    protected StandalonePoolServer(String id, RJContext context) throws RjInitFailedException {
        super(id, context);
    }

    public static void main(String[] args) throws Exception {
        StandalonePoolServer server = StandalonePoolServer.initServer(args);
        try {
            server.start();
        }
        catch (OperationsException e) {
            CommonsRuntime.log((Status)new WarningStatus("org.eclipse.statet.rj.servi", "The server is started, but the pool could not be started.", (Throwable)e));
        }
    }

    static StandalonePoolServer initServer(String[] args) throws StatusException, RjInitFailedException {
        String id;
        String string = id = args.length > 0 ? args[0] : null;
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("No pool id specified.");
        }
        CommonsRuntime.check((boolean)true);
        RJContext context = new RJContext(){

            public String getServerPolicyFilePath() throws RjInvalidConfigurationException {
                String path = String.valueOf(this.getPropertiesDirPath()) + "security.policy";
                if (new File(path).exists()) {
                    return path;
                }
                return super.getServerPolicyFilePath();
            }
        };
        return new StandalonePoolServer(id, context);
    }
}

