/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.server;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.http.RHelpHttpServlet;
import org.eclipse.statet.rhelp.core.http.jetty.JettyRHelpUtils;
import org.springframework.beans.factory.annotation.Autowired;

@WebServlet(urlPatterns={"/rhelp/browse/*"})
@NonNullByDefault
public class RHelpServerBrowseServlet
extends RHelpHttpServlet {
    private static final long serialVersionUID = 1L;
    private final RHelpManager rHelpManager;

    @Autowired
    public RHelpServerBrowseServlet(RHelpManager rHelpManager) {
        this.rHelpManager = rHelpManager;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.init(this.rHelpManager, JettyRHelpUtils.newResourceHandler((ServletContext)config.getServletContext()), null);
    }

    protected StringBuilder getServletPath(HttpServletRequest req) {
        String requestPath = URIUtil.canonicalPath((String)req.getPathInfo());
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i < requestPath.length()) {
            if (requestPath.charAt(i++) != '/') continue;
            sb.append("../");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }
}

