/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.statet.docmlet.base.ui.DocmlBaseUIResources;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigManager;
import org.eclipse.statet.internal.docmlet.base.ui.processing.DocProcessingRegistry;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.collections.IdentityCollection;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public class DocProcessingManager
extends LaunchConfigManager<IFile>
implements ILaunchConfigurationListener,
Disposable {
    protected static final byte WEAVE_BIT = 2;
    protected static final byte PRODUCE_OUTPUT_BIT = 8;
    protected static final byte OPEN_OUTPUT_BIT = 32;

    public void init(DocProcessingRegistry.ManagerConfig config) {
        super.init(config.contentTypeId, config.configTypeId);
    }

    protected byte getBits(IdentityCollection<String> flags) {
        byte bits;
        if (flags.contains((Object)"processing_steps")) {
            bits = 10;
        } else {
            bits = 0;
            if (flags.contains((Object)"weave")) {
                bits = (byte)(bits | 2);
            }
            if (flags.contains((Object)"produce_output")) {
                bits = (byte)(bits | 8);
            }
            if (flags.contains((Object)"open_output")) {
                bits = (byte)(bits | 0x20);
            }
        }
        return bits;
    }

    protected boolean getBuildBeforeLaunch(byte bits) {
        return bits == 0 || (bits & 2) != 0;
    }

    protected Map<String, Object> createRunAttributes(IFile element, IdentitySet<String> flags) {
        IdentityHashMap<String, Object> map = new IdentityHashMap<String, Object>(4);
        map.put("org.eclipse.statet.docmlet.base/run/ContentType.id", this.getContentTypeId());
        if (flags != null) {
            map.put("org.eclipse.statet.docmlet.base/run/BuildSteps.set", flags);
        }
        if (element != null) {
            map.put("org.eclipse.statet.docmlet.base/run/DocSource.path", element.getFullPath().toPortableString());
        }
        return map;
    }

    protected @Nullable Image getActionImage(byte bits) {
        return switch (bits) {
            case 0, 42 -> DocmlBaseUIResources.INSTANCE.getImage("org.eclipse.statet.docmlet.base/image/tool/ProcessAndPreview");
            case 10 -> DocmlBaseUIResources.INSTANCE.getImage("org.eclipse.statet.docmlet.base/image/tool/Process");
            case 8 -> DocmlBaseUIResources.INSTANCE.getImage("org.eclipse.statet.docmlet.base/image/tool/Preview");
            default -> null;
        };
    }

    protected String getActionLabel(byte bits) {
        return switch (bits) {
            case 0, 42 -> Messages.ProcessingAction_ProcessAndPreview_label;
            case 10 -> Messages.ProcessingAction_ProcessDoc_label;
            case 2 -> Messages.ProcessingAction_Weave_label;
            case 8 -> Messages.ProcessingAction_ProduceOutput_label;
            case 32 -> Messages.ProcessingAction_PreviewOutput_label;
            default -> throw new IllegalArgumentException();
        };
    }
}

