/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.source.doc;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.statet.docmlet.tex.core.source.doc.LtxPartitionNodeType;
import org.eclipse.statet.ecommons.text.CharacterScannerReader;
import org.eclipse.statet.ecommons.text.core.rules.BufferedDocumentScanner;
import org.eclipse.statet.ecommons.text.core.rules.OperatorRule;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScan;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.jcommons.lang.Nullable;

public class LtxPartitionNodeScanner
implements TreePartitionNodeScanner {
    protected static final int S_DEFAULT = 0;
    protected static final int S_MATH_SPECIAL_$ = 1;
    protected static final int S_MATH_SPECIAL_S = 2;
    protected static final int S_MATH_SPECIAL_P = 3;
    protected static final int S_MATH_ENV = 4;
    protected static final int S_VERBATIM_LINE = 5;
    protected static final int S_VERBATIM_ENV = 6;
    protected static final int S_COMMENT_LINE = 7;
    protected static final int S_COMMENT_ENV = 8;
    protected static final int S_MATHCOMMENT_LINE = 9;
    protected static final int S_EXT_LTX = 10;
    protected static final int LAST_OTHER = 0;
    protected static final int LAST_EOF = 1;
    protected static final int LAST_NEWLINE = 2;
    private static final char[] SEQ_begin = "begin".toCharArray();
    private static final char[] SEQ_verb = "verb".toCharArray();
    protected final boolean templateMode;
    protected final CharacterScannerReader reader = new CharacterScannerReader(new BufferedDocumentScanner(1024));
    private TreePartitionNodeScan scan;
    private TreePartitionNode rootNode;
    private TreePartitionNode node;
    private LtxPartitionNodeType type;
    protected int last;
    private boolean searchInternalEnvEnd;
    private final OperatorRule envNameRule;
    private final Map<String, LtxPartitionNodeType.AbstractEnv> envTypes;

    /*
     * Unable to fully structure code
     */
    public static final @Nullable TreePartitionNode findLtxRootNode(@Nullable TreePartitionNode node) {
        while (true) {
            block3: {
                if (node == null) {
                    return null;
                }
                if (!(node.getType() instanceof LtxPartitionNodeType)) break block3;
                ltxNode = node;
                if (true) ** GOTO lbl12
            }
            node = node.getParent();
        }
        do {
            ltxNode = parentNode;
lbl12:
            // 2 sources

        } while ((parentNode = ltxNode.getParent()) != null && parentNode.getType() instanceof LtxPartitionNodeType);
        return ltxNode;
    }

    public LtxPartitionNodeScanner() {
        this(false);
    }

    public LtxPartitionNodeScanner(boolean templateMode) {
        this.templateMode = templateMode;
        this.envNameRule = new OperatorRule(new char[0]);
        this.envTypes = new HashMap<String, LtxPartitionNodeType.AbstractEnv>(24);
        this.initEnvs();
    }

    protected void addEnvRule(LtxPartitionNodeType.AbstractEnv type) {
        this.envTypes.put(type.getEnvName(), type);
        this.envNameRule.addOp(type.getEnvName(), null);
    }

    protected void initEnvs() {
        this.addEnvRule(LtxPartitionNodeType.COMMENT_ENV_comment);
        this.addEnvRule(LtxPartitionNodeType.VERBATIM_ENV_verbatim);
        this.addEnvRule(LtxPartitionNodeType.VERBATIM_ENV_verbatimA);
        this.addEnvRule(LtxPartitionNodeType.VERBATIM_ENV_lstlisting);
        this.addEnvRule(LtxPartitionNodeType.VERBATIM_ENV_Sinput);
        this.addEnvRule(LtxPartitionNodeType.VERBATIM_ENV_Soutput);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_equation);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_eqnarray);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_eqnarrayA);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_math);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_displaymath);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_multline);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_multlineA);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_gather);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_gatherA);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_align);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_alignA);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_alignat);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_alignatA);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_flalign);
        this.addEnvRule(LtxPartitionNodeType.MATH_ENV_flalignA);
    }

    public int getRestartOffset(TreePartitionNode node, IDocument document, int offset) throws BadLocationException {
        do {
            if (!(node.getType() instanceof LtxPartitionNodeType.MathEnv)) continue;
            return node.getStartOffset();
        } while ((node = node.getParent()) != null);
        return offset;
    }

    public LtxPartitionNodeType getDefaultRootType() {
        return LtxPartitionNodeType.DEFAULT_ROOT;
    }

    public void execute(TreePartitionNodeScan scan) {
        this.scan = scan;
        this.rootNode = null;
        this.node = null;
        this.searchInternalEnvEnd = false;
        this.setRange(scan.getStartOffset(), scan.getEndOffset());
        this.init();
        assert (this.rootNode != null && this.node != null);
        this.process();
    }

    protected TreePartitionNodeScan getScan() {
        return this.scan;
    }

    protected void setRange(int startOffset, int endOffset) {
        this.reader.setRange(this.getScan().getDocument(), startOffset, endOffset - startOffset);
        this.updateLast();
    }

    protected void init() {
        TreePartitionNode beginNode = this.getScan().getBeginNode();
        if (beginNode.getType() instanceof LtxPartitionNodeType) {
            this.initNode(beginNode, (LtxPartitionNodeType)beginNode.getType());
        } else {
            this.node = beginNode;
            this.addNode(this.getDefaultRootType(), this.getScan().getStartOffset());
            this.rootNode = this.node;
        }
    }

    protected final TreePartitionNode getRootNode() {
        return this.rootNode;
    }

    private void updateLast() {
        if (this.reader.getOffset() > 0) {
            this.last = 0;
            try {
                char c = this.getScan().getDocument().getChar(this.reader.getOffset() - 1);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        this.last = 2;
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            this.last = 2;
        }
    }

    protected final void initNode(TreePartitionNode node, LtxPartitionNodeType type) {
        if (this.node != null) {
            throw new IllegalStateException();
        }
        this.node = node;
        this.type = type;
        this.rootNode = LtxPartitionNodeScanner.findLtxRootNode(node);
    }

    protected final void addNode(LtxPartitionNodeType type, int offset) {
        this.node = this.scan.add((TreePartitionNodeType)type, this.node, offset, 0);
        this.type = type;
    }

    protected final void addNode(TreePartitionNodeType type, LtxPartitionNodeType ltxType, int offset) {
        this.node = this.scan.add(type, this.node, offset, 0);
        this.type = ltxType;
    }

    protected final TreePartitionNode getNode() {
        return this.node;
    }

    protected final void exitNode(int offset, int flags) {
        this.scan.expand(this.node, offset, flags, true);
        this.node = this.node.getParent();
        this.type = (LtxPartitionNodeType)this.node.getType();
    }

    protected final void exitNode() {
        this.node = this.node.getParent();
        this.type = (LtxPartitionNodeType)this.node.getType();
    }

    protected final void exitNodesTo(TreePartitionNode stopNode, int offset, int flags) {
        while (this.node != stopNode) {
            this.exitNode(offset, flags);
        }
    }

    private void process() {
        block14: while (true) {
            switch (this.last) {
                case 1: {
                    this.handleEOF(this.type);
                    return;
                }
                case 2: {
                    this.handleNewLine(this.type);
                    break;
                }
            }
            switch (this.type.getScannerState()) {
                case 0: {
                    this.processDefault();
                    continue block14;
                }
                case 1: {
                    this.processMathSpecial_$();
                    continue block14;
                }
                case 2: {
                    this.processMathSpecial_S();
                    continue block14;
                }
                case 3: {
                    this.processMathSpecial_P();
                    continue block14;
                }
                case 4: {
                    this.processMathEnv();
                    continue block14;
                }
                case 5: {
                    this.processVerbatimLine();
                    continue block14;
                }
                case 7: 
                case 9: {
                    this.processCommentLine();
                    continue block14;
                }
                case 6: 
                case 8: {
                    this.processVerbatimEnv();
                    continue block14;
                }
            }
            this.processExt(this.type);
        }
    }

    protected void processDefault() {
        block17: while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = 2;
                    return;
                }
                case 10: {
                    this.last = 2;
                    return;
                }
                case 92: {
                    int c = this.reader.read();
                    switch (c) {
                        case -1: {
                            this.last = 1;
                            return;
                        }
                        case 13: {
                            this.reader.read('\n');
                            this.last = 2;
                            return;
                        }
                        case 10: {
                            this.last = 2;
                            return;
                        }
                        case 98: {
                            if (!this.reader.read2(SEQ_begin)) break;
                            this.checkForBeginEnv();
                            return;
                        }
                        case 118: {
                            if (!this.reader.read2(SEQ_verb)) break;
                            int c6 = this.reader.read();
                            if (c6 > 32 && Character.isLetter(c6)) {
                                this.addNode(new LtxPartitionNodeType.VerbatimInline((char)c6), this.reader.getOffset() - 6);
                                return;
                            }
                            if (c6 < 0) break;
                            this.reader.unread();
                            break;
                        }
                        case 91: {
                            this.addNode(LtxPartitionNodeType.MATH_SPECIAL_S, this.reader.getOffset() - 2);
                            return;
                        }
                        case 40: {
                            this.addNode(LtxPartitionNodeType.MATH_SPECIAL_P, this.reader.getOffset() - 2);
                            return;
                        }
                    }
                    if (!this.searchExtCommand(c)) continue block17;
                    return;
                }
                case 37: {
                    this.addNode(LtxPartitionNodeType.COMMENT_LINE, this.reader.getOffset() - 1);
                    this.last = 0;
                    return;
                }
                case 36: {
                    this.last = 0;
                    if (this.templateMode) {
                        if (!this.reader.read('$')) continue block17;
                        if (this.reader.read('$', '$')) {
                            this.addNode(LtxPartitionNodeType.MATH_SPECIAL_$$_TEMPL, this.reader.getOffset() - 4);
                            return;
                        }
                        this.addNode(LtxPartitionNodeType.MATH_SPECIAL_$_TEMPL, this.reader.getOffset() - 2);
                        return;
                    }
                    if (this.reader.read('$')) {
                        this.addNode(LtxPartitionNodeType.MATH_SPECIAL_$$, this.reader.getOffset() - 2);
                        return;
                    }
                    this.addNode(LtxPartitionNodeType.MATH_SPECIAL_$, this.reader.getOffset() - 1);
                    return;
                }
            }
        }
    }

    protected void processMathSpecial_P() {
        block13: while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = 2;
                    return;
                }
                case 10: {
                    this.last = 2;
                    return;
                }
                case 92: {
                    int c = this.reader.read();
                    switch (c) {
                        case -1: {
                            this.last = 1;
                            return;
                        }
                        case 13: {
                            this.reader.read('\n');
                            this.last = 2;
                            return;
                        }
                        case 10: {
                            this.last = 2;
                            return;
                        }
                        case 41: {
                            this.last = 0;
                            this.exitNode(this.reader.getOffset(), 0);
                            return;
                        }
                    }
                    if (!this.searchExtCommand(c)) continue block13;
                    return;
                }
                case 37: {
                    this.addNode(LtxPartitionNodeType.MATHCOMMENT_LINE, this.reader.getOffset() - 1);
                    this.last = 0;
                    return;
                }
            }
        }
    }

    protected void processMathSpecial_S() {
        block13: while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = 2;
                    return;
                }
                case 10: {
                    this.last = 2;
                    return;
                }
                case 92: {
                    int c = this.reader.read();
                    switch (c) {
                        case -1: {
                            this.last = 1;
                            return;
                        }
                        case 13: {
                            this.reader.read('\n');
                            this.last = 2;
                            return;
                        }
                        case 10: {
                            this.last = 2;
                            return;
                        }
                        case 93: {
                            this.exitNode(this.reader.getOffset(), 0);
                            this.last = 0;
                            return;
                        }
                    }
                    if (!this.searchExtCommand(c)) continue block13;
                    return;
                }
                case 37: {
                    this.addNode(LtxPartitionNodeType.MATHCOMMENT_LINE, this.reader.getOffset() - 1);
                    this.last = 0;
                    return;
                }
            }
        }
    }

    protected void processMathSpecial_$() {
        block13: while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = 2;
                    return;
                }
                case 10: {
                    this.last = 2;
                    return;
                }
                case 92: {
                    int c = this.reader.read();
                    switch (c) {
                        case -1: {
                            this.last = 1;
                            return;
                        }
                        case 13: {
                            this.reader.read('\n');
                            this.last = 2;
                            return;
                        }
                        case 10: {
                            this.last = 2;
                            return;
                        }
                    }
                    if (!this.searchExtCommand(c)) continue block13;
                    return;
                }
                case 37: {
                    this.addNode(LtxPartitionNodeType.MATHCOMMENT_LINE, this.reader.getOffset() - 1);
                    this.last = 0;
                    return;
                }
                case 36: {
                    if (!this.reader.readConsuming2(this.type.getEndPattern())) continue block13;
                    this.exitNode(this.reader.getOffset(), 0);
                    this.last = 0;
                    return;
                }
            }
        }
    }

    protected void processMathEnv() {
        if (this.searchInternalEnvEnd) {
            this.searchInternalEnvEnd();
            return;
        }
        block13: while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = 2;
                    return;
                }
                case 10: {
                    this.last = 2;
                    return;
                }
                case 92: {
                    int c = this.reader.read();
                    switch (c) {
                        case -1: {
                            this.last = 1;
                            return;
                        }
                        case 13: {
                            this.reader.read('\n');
                            this.last = 2;
                            return;
                        }
                        case 10: {
                            this.last = 2;
                            return;
                        }
                        case 101: {
                            if (!this.reader.readConsuming('n', 'd')) break;
                            this.searchInternalEnvEnd = true;
                            this.searchInternalEnvEnd();
                            return;
                        }
                    }
                    if (!this.searchExtCommand(c)) continue block13;
                    return;
                }
                case 37: {
                    this.addNode(LtxPartitionNodeType.MATHCOMMENT_LINE, this.reader.getOffset() - 1);
                    this.last = 0;
                    return;
                }
            }
        }
    }

    protected void processVerbatimEnv() {
        block6: while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = 2;
                    return;
                }
                case 10: {
                    this.last = 2;
                    return;
                }
                case 92: {
                    if (!this.reader.readConsuming(this.type.getEndPattern())) continue block6;
                    this.exitNode(this.reader.getOffset(), 0);
                    this.last = 0;
                    return;
                }
            }
        }
    }

    protected void processVerbatimLine() {
        int c;
        char end = this.type.getEndChar();
        do {
            c = this.reader.read();
            switch (c) {
                case -1: {
                    this.exitNode(this.reader.getOffset(), 256);
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.exitNode(this.reader.getOffset() - 1, 256);
                    this.reader.read('\n');
                    this.last = 2;
                    return;
                }
                case 10: {
                    this.exitNode(this.reader.getOffset() - 1, 256);
                    this.last = 2;
                    return;
                }
            }
        } while (c != end);
        this.exitNode(this.reader.getOffset(), 0);
        this.last = 0;
    }

    protected void processCommentLine() {
        while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = 2;
                    this.exitNode(this.reader.getOffset(), 0);
                    return;
                }
                case 10: {
                    this.last = 2;
                    this.exitNode(this.reader.getOffset(), 0);
                    return;
                }
            }
        }
    }

    protected void searchInternalEnvEnd() {
        block7: while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = 2;
                    return;
                }
                case 10: {
                    this.last = 2;
                    return;
                }
                case 9: 
                case 32: {
                    continue block7;
                }
                case 123: {
                    if (this.reader.readConsuming(this.type.getEndPattern())) {
                        this.reader.read('}');
                        this.exitNode(this.reader.getOffset(), 0);
                        this.last = 0;
                        return;
                    }
                    this.searchInternalEnvEnd = false;
                    this.last = 0;
                    return;
                }
            }
            break;
        }
        this.reader.unread();
        this.searchInternalEnvEnd = false;
        this.last = 0;
    }

    protected void processExt(LtxPartitionNodeType type) {
        throw new IllegalStateException("type= " + (Object)((Object)type));
    }

    private void checkForBeginEnv() {
        BufferedDocumentScanner scanner = this.reader.getScanner();
        int count = this.readWhitespace(scanner);
        ++count;
        int c = scanner.read();
        if (c == 42) {
            count += this.readWhitespace(scanner);
            ++count;
            c = scanner.read();
        }
        if (c != 123) {
            this.reader.unreadRaw(c >= 0 ? count : count - 1);
            return;
        }
        String name = this.envNameRule.searchString((ICharacterScanner)scanner);
        if (name == null) {
            this.reader.unreadRaw(count);
            return;
        }
        count += name.length();
        ++count;
        c = scanner.read();
        if (c != 125) {
            this.reader.unreadRaw(c >= 0 ? count : count - 1);
            return;
        }
        this.reader.unreadRaw(count);
        this.addNode(this.envTypes.get(name), this.reader.getOffset() - 6);
    }

    public final int readWhitespace(BufferedDocumentScanner scanner) {
        int c;
        int readed = 0;
        while ((c = scanner.read()) == 32 || c == 13 || c == 10 || c == 9) {
            ++readed;
        }
        if (c >= 0) {
            scanner.unread();
        }
        return readed;
    }

    protected boolean searchExtCommand(int c) {
        return false;
    }

    protected void handleNewLine(LtxPartitionNodeType type) {
    }

    protected void handleEOF(LtxPartitionNodeType type) {
        this.exitNodesTo(this.getRootNode(), this.reader.getOffset(), 256);
        this.scan.expand(this.node, this.reader.getOffset(), 256, true);
    }
}

