/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.List;
import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlinesSubstitution;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public abstract class Inline
implements TextRegion {
    private final Line line;
    private final int startOffset;
    private final int length;
    private final int cursorLength;

    public Inline(Line line, int offset, int length, int cursorLength) {
        if (offset < 0 || length <= 0) {
            throw new IllegalArgumentException();
        }
        this.line = (Line)ObjectUtils.nonNullAssert((Object)line);
        this.startOffset = offset;
        this.length = length;
        this.cursorLength = cursorLength;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.startOffset + this.length;
    }

    public int getLength() {
        return this.length;
    }

    public Line getLine() {
        return this.line;
    }

    protected int getCursorLength() {
        return this.cursorLength;
    }

    void apply(ProcessingContext context, List<Inline> inlines, Cursor cursor, boolean inBlock) {
        cursor.advance(this.getCursorLength());
        inlines.add(this);
    }

    @Nullable InlinesSubstitution secondPass(List<Inline> inlines) {
        return null;
    }

    public abstract void emit(ProcessingContext var1, CommonmarkLocator var2, DocumentBuilder var3);

    public int hashCode() {
        return Objects.hash(this.startOffset, this.length);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Inline other = (Inline)obj;
            return this.startOffset == other.startOffset && this.length == other.length;
        }
        return false;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(this.getClass(), this.getClass());
        sb.addProp("startOffset", this.getStartOffset());
        sb.addProp("length", this.getLength());
        return sb.build();
    }
}

