/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.statet.docmlet.wikitext.core.ast.Link;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextModel;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceUnit;
import org.eclipse.statet.internal.docmlet.wikitext.ui.editors.MarkupOpenHyperlinkHandler;
import org.eclipse.statet.internal.docmlet.wikitext.ui.editors.OpenMarkupElementHyperlink;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.util.OpenWorkspaceFileHyperlink;

@NonNullByDefault
public class MarkupHyperlinkDetector
extends AbstractHyperlinkDetector {
    public @NonNull IHyperlink @Nullable [] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        SourceEditor editor = (SourceEditor)this.getAdapter(SourceEditor.class);
        if (editor == null) {
            return null;
        }
        WikitextSourceUnit sourceUnit = WikitextModel.asWikitextSourceUnit((SourceUnit)editor.getSourceUnit());
        if (sourceUnit == null) {
            return null;
        }
        ArrayList<OpenMarkupElementHyperlink> hyperlinks = new ArrayList<OpenMarkupElementHyperlink>(4);
        Link link = MarkupOpenHyperlinkHandler.searchLink(sourceUnit, region);
        if (link != null) {
            if (link.getLinkType() == 2) {
                for (Object attachment : link.getAttachments()) {
                    if (!(attachment instanceof WikitextNameAccess)) continue;
                    hyperlinks.add(new OpenMarkupElementHyperlink(editor, sourceUnit, (WikitextNameAccess)attachment));
                    break;
                }
            } else {
                String uri = link.getUri();
                if (uri != null && !uri.isEmpty()) {
                    if (uri.charAt(0) == '#') {
                        if (uri.length() > 1) {
                            hyperlinks.add(new OpenMarkupElementHyperlink(editor, sourceUnit, (TextRegion)link, uri.substring(1)));
                        }
                    } else {
                        List<IFile> files = MarkupOpenHyperlinkHandler.refLocalFile(editor, link);
                        for (IFile file : files) {
                            hyperlinks.add((OpenMarkupElementHyperlink)new OpenWorkspaceFileHyperlink((TextRegion)link, file));
                        }
                    }
                }
            }
        }
        if (!hyperlinks.isEmpty()) {
            return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
        }
        return null;
    }
}

