/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.editors;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceUnit;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.internal.docmlet.wikitext.ui.editors.Messages;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.element.NameAccess;
import org.eclipse.statet.ltk.model.core.element.NameAccessSet;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.actions.OpenDeclaration;
import org.eclipse.swt.widgets.Display;

public class OpenMarkupElementHyperlink
implements IHyperlink {
    private final SourceEditor editor;
    private final IRegion region;
    private final WikitextSourceUnit sourceUnit;
    private final WikitextNameAccess access;
    private final String label;

    public OpenMarkupElementHyperlink(SourceEditor editor, WikitextSourceUnit sourceUnit, TextRegion region, String label) {
        assert (sourceUnit != null);
        assert (label != null);
        this.editor = editor;
        this.region = JFaceTextRegion.toJFaceRegion((TextRegion)region);
        this.sourceUnit = sourceUnit;
        this.access = null;
        this.label = label;
    }

    public OpenMarkupElementHyperlink(SourceEditor editor, WikitextSourceUnit sourceUnit, WikitextNameAccess access) {
        assert (sourceUnit != null);
        assert (access != null);
        this.editor = editor;
        this.region = JFaceTextRegion.toJFaceRegion((TextRegion)(access.getNameNode() != null ? access.getNameNode() : access.getNode()));
        this.sourceUnit = sourceUnit;
        this.access = access;
        this.label = this.access.getSegmentName();
    }

    public String getTypeLabel() {
        return null;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return NLS.bind((String)Messages.Hyperlinks_OpenDeclaration_label, (Object)this.label);
    }

    public void open() {
        WikidocSourceUnitModelInfo modelInfo = (WikidocSourceUnitModelInfo)this.sourceUnit.getModelInfo("Wikidoc", 2, (IProgressMonitor)new NullProgressMonitor());
        if (modelInfo != null) {
            NameAccessSet labels;
            int type = this.access != null ? this.access.getType() : 65;
            switch (type) {
                case 69: {
                    labels = modelInfo.getLinkRefLabels();
                    break;
                }
                case 65: {
                    labels = modelInfo.getLinkAnchorLabels();
                    break;
                }
                default: {
                    return;
                }
            }
            OpenDeclaration open = new OpenDeclaration();
            WikitextNameAccess declAccess = (WikitextNameAccess)open.selectAccess((List)labels.getAllInUnit(this.label));
            if (declAccess != null) {
                open.open(this.editor, (NameAccess)declAccess);
                return;
            }
            Display.getCurrent().beep();
        }
    }
}

