/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.core;

import java.util.function.Function;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class PreferenceObjectDef<TObject> {
    private final Class<TObject> type;
    private final ImSet<String> qualifiers;

    public PreferenceObjectDef(Class<TObject> type, ImSet<String> qualifiers) {
        this.type = type;
        this.qualifiers = qualifiers;
    }

    public Class<TObject> getType() {
        return this.type;
    }

    public ImSet<String> getQualifiers() {
        return this.qualifiers;
    }

    public boolean isRelevant(PreferenceSetService.ChangeEvent event) {
        return true;
    }

    public abstract TObject create(PreferenceAccess var1);

    public static <TObject> PreferenceObjectDef<TObject> createFactory(Class<TObject> type, ImSet<String> qualifiers, final Function<PreferenceAccess, TObject> objectFactory) {
        return new PreferenceObjectDef<TObject>(type, qualifiers){

            @Override
            public TObject create(PreferenceAccess prefs) {
                return objectFactory.apply(prefs);
            }
        };
    }
}

