/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.command;

import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class AbstractDimPositionCommand
implements LayerCommand {
    private LayerDim layerDim;
    private long position;

    protected AbstractDimPositionCommand(LayerDim layerDim, long position) {
        this.layerDim = layerDim;
        this.position = position;
    }

    protected AbstractDimPositionCommand(AbstractDimPositionCommand command) {
        this.layerDim = command.layerDim;
        this.position = command.position;
    }

    public final Orientation getOrientation() {
        return this.layerDim.getOrientation();
    }

    public final LayerDim getDim() {
        return this.layerDim;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public boolean convertToTargetLayer(Layer targetLayer) {
        LayerDim targetLayerDim = targetLayer.getDim(this.getOrientation());
        if (this.layerDim == targetLayerDim) {
            return true;
        }
        return this.convertToTargetLayer(this.layerDim, this.position, targetLayerDim);
    }

    protected boolean convertToTargetLayer(LayerDim dim, long position, LayerDim targetDim) {
        long targetPosition = LayerUtils.convertPosition(dim, position, position, targetDim);
        if (targetPosition == Long.MIN_VALUE) {
            return false;
        }
        this.layerDim = targetDim;
        this.position = targetPosition;
        return true;
    }
}

